/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.mixin.base;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.spectator.SpectatorGui;
import net.minecraft.client.gui.contextualbar.ContextualBarRenderer;
import net.minecraft.client.gui.contextualbar.ExperienceBarRenderer;
import net.minecraft.client.gui.contextualbar.JumpableVehicleBarRenderer;
import net.minecraft.client.gui.contextualbar.LocatorBarRenderer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.Objective;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.GuiAccessor;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.client.UIDefinition;
import wily.factoryapi.util.FactoryGuiElement;
import wily.factoryapi.util.VariablesMap;

@Mixin(value={Gui.class})
public abstract class GuiMixin
implements UIAccessor,
GuiAccessor {
    @Shadow
    private int overlayMessageTime;
    @Shadow
    @Nullable
    private Component overlayMessageString;
    @Unique
    private final List<Renderable> renderables = new ArrayList<Renderable>();
    @Unique
    private final VariablesMap<String, ArbitrarySupplier<?>> elements = new VariablesMap();
    @Unique
    private final List<UIDefinition> definitions = new ArrayList<UIDefinition>();
    @Unique
    private final List<UIDefinition> staticDefinitions = new ArrayList<UIDefinition>();
    @Unique
    final ThreadLocal<CallbackInfo> ci = new ThreadLocal();
    @Unique
    final ThreadLocal<FactoryGuiElement> fge = new ThreadLocal();

    @Override
    @Nullable
    public Screen getScreen() {
        return null;
    }

    @Override
    public boolean initialized() {
        return true;
    }

    @Override
    public List<UIDefinition> getDefinitions() {
        return this.definitions;
    }

    @Override
    public List<UIDefinition> getStaticDefinitions() {
        return this.staticDefinitions;
    }

    @Override
    public List<GuiEventListener> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public List<Renderable> getChildrenRenderables() {
        return this.renderables;
    }

    @Override
    public <T extends GuiEventListener> T removeChild(T listener) {
        if (listener instanceof Renderable) {
            Renderable r = (Renderable)listener;
            this.renderables.remove(r);
        }
        return listener;
    }

    @Override
    public <T extends GuiEventListener> T addChild(int renderableIndex, T listener, boolean isRenderable, boolean isNarratable) {
        if (listener instanceof Renderable) {
            Renderable r = (Renderable)listener;
            this.addRenderable(renderableIndex, r);
        }
        return listener;
    }

    @Override
    public void beforeInit(UIAccessor accessor) {
        UIAccessor.super.beforeInit(accessor);
        this.putSupplierComponent("overlayMessage.component", () -> this.overlayMessageString == null ? CommonComponents.EMPTY : this.overlayMessageString);
        this.getElements().put("overlayMessage.time", Bearer.of(() -> this.overlayMessageTime, i -> {
            this.overlayMessageTime = i;
        }));
    }

    @Override
    public VariablesMap<String, ArbitrarySupplier<?>> getElements() {
        return this.elements;
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    public void beforeTick(CallbackInfo ci) {
        this.beforeTick();
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    public void afterTick(CallbackInfo ci) {
        this.afterTick();
    }

    @Inject(method={"renderVignette"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderVignette(GuiGraphics guiGraphics, Entity entity, CallbackInfo ci) {
        FactoryGuiElement.VIGNETTE.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderVignette"}, at={@At(value="RETURN")})
    public void renderVignetteReturn(GuiGraphics guiGraphics, Entity entity, CallbackInfo ci) {
        FactoryGuiElement.VIGNETTE.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"renderCrosshair"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderCrosshair(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        FactoryGuiElement.CROSSHAIR.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderCrosshair"}, at={@At(value="RETURN")})
    public void renderCrosshairReturn(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        FactoryGuiElement.CROSSHAIR.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"renderEffects"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderEffects(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        FactoryGuiElement.EFFECTS.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderEffects"}, at={@At(value="RETURN")})
    public void renderEffectsReturn(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        FactoryGuiElement.EFFECTS.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"renderItemHotbar"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderHotbar(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        FactoryGuiElement.HOTBAR.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderItemHotbar"}, at={@At(value="RETURN")})
    public void renderHotbarReturn(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        FactoryGuiElement.HOTBAR.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"displayScoreboardSidebar"}, at={@At(value="HEAD")}, cancellable=true)
    private void displayScoreboardSidebar(GuiGraphics guiGraphics, Objective objective, CallbackInfo ci) {
        FactoryGuiElement.SCOREBOARD.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"displayScoreboardSidebar"}, at={@At(value="RETURN")})
    private void displayScoreboardSidebarReturn(GuiGraphics guiGraphics, Objective objective, CallbackInfo ci) {
        FactoryGuiElement.SCOREBOARD.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"renderOverlayMessage"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderOverlayMessage(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        FactoryGuiElement.OVERLAY_MESSAGE.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderOverlayMessage"}, at={@At(value="RETURN")})
    public void renderOverlayMessageReturn(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        FactoryGuiElement.OVERLAY_MESSAGE.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"renderPlayerHealth"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderHealth(GuiGraphics guiGraphics, CallbackInfo ci) {
        FactoryGuiElement.PLAYER_HEALTH.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderPlayerHealth"}, at={@At(value="RETURN")})
    public void renderHealthReturn(GuiGraphics guiGraphics, CallbackInfo ci) {
        FactoryGuiElement.PLAYER_HEALTH.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"renderVehicleHealth"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderVehicleHealth(GuiGraphics guiGraphics, CallbackInfo ci) {
        FactoryGuiElement.VEHICLE_HEALTH.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderVehicleHealth"}, at={@At(value="RETURN")})
    public void renderVehicleHealthReturn(GuiGraphics guiGraphics, CallbackInfo ci) {
        FactoryGuiElement.VEHICLE_HEALTH.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"renderHealthLevel", "renderArmorLevel", "renderFoodLevel", "renderAirLevel"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void renderNeoForgeHealth(GuiGraphics guiGraphics, CallbackInfo ci) {
        FactoryGuiElement.PLAYER_HEALTH.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderHealthLevel", "renderArmorLevel", "renderFoodLevel", "renderAirLevel"}, at={@At(value="RETURN")}, remap=false)
    public void renderNeoForgeHealthReturn(GuiGraphics guiGraphics, CallbackInfo ci) {
        FactoryGuiElement.PLAYER_HEALTH.finalizeMixin(guiGraphics, this);
    }

    @WrapOperation(method={"renderContextualInfoBarBackground"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/contextualbar/ContextualBarRenderer;renderBackground(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V")})
    public void renderExperienceBar(ContextualBarRenderer instance, GuiGraphics graphics, DeltaTracker deltaTracker, Operation<Void> original) {
        this.ci.set(new CallbackInfo("renderContextualBar", true));
        ContextualBarRenderer contextualBarRenderer = instance;
        Objects.requireNonNull(contextualBarRenderer);
        ContextualBarRenderer contextualBarRenderer2 = contextualBarRenderer;
        int n = 0;
        this.fge.set(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExperienceBarRenderer.class, LocatorBarRenderer.class, JumpableVehicleBarRenderer.class}, (Object)contextualBarRenderer2, n)) {
            case 0 -> {
                ExperienceBarRenderer ignored = (ExperienceBarRenderer)contextualBarRenderer2;
                yield FactoryGuiElement.EXPERIENCE_BAR;
            }
            case 1 -> {
                LocatorBarRenderer ignored = (LocatorBarRenderer)contextualBarRenderer2;
                yield FactoryGuiElement.LOCATOR_BAR;
            }
            case 2 -> {
                JumpableVehicleBarRenderer ignored = (JumpableVehicleBarRenderer)contextualBarRenderer2;
                yield FactoryGuiElement.JUMP_METER;
            }
            default -> null;
        });
        FactoryGuiElement factoryGuiElement = this.fge.get();
        if (factoryGuiElement != null) {
            factoryGuiElement.prepareMixin(graphics, this, this.ci.get());
        }
        if (!this.ci.get().isCancelled()) {
            original.call(new Object[]{instance, graphics, deltaTracker});
        }
    }

    @WrapOperation(method={"renderContextualInfoBar"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/contextualbar/ContextualBarRenderer;render(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V")})
    public void renderExperienceBarReturn(ContextualBarRenderer instance, GuiGraphics graphics, DeltaTracker deltaTracker, Operation<Void> original) {
        FactoryGuiElement factoryGuiElement;
        if (!this.ci.get().isCancelled()) {
            original.call(new Object[]{instance, graphics, deltaTracker});
        }
        if ((factoryGuiElement = this.fge.get()) != null) {
            factoryGuiElement.finalizeMixin(graphics, this);
        }
        this.fge.remove();
        this.ci.remove();
    }

    @Inject(method={"renderSelectedItemName(Lnet/minecraft/client/gui/GuiGraphics;I)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void renderSelectedItemName(GuiGraphics guiGraphics, int shift, CallbackInfo ci) {
        FactoryGuiElement.SELECTED_ITEM_NAME.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderSelectedItemName(Lnet/minecraft/client/gui/GuiGraphics;I)V"}, at={@At(value="RETURN")}, remap=false)
    public void renderSelectedItemNameReturn(GuiGraphics guiGraphics, int shift, CallbackInfo ci) {
        FactoryGuiElement.SELECTED_ITEM_NAME.finalizeMixin(guiGraphics, this);
    }

    @Override
    @Accessor
    public abstract SpectatorGui getSpectatorGui();

    @Override
    @Accessor
    public abstract ItemStack getLastToolHighlight();

    @Override
    @Accessor
    public abstract int getToolHighlightTimer();
}

