/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.util.CompoundTagUtil;

public class FluidInstance
implements DataComponentHolder {
    private final Fluid fluid;
    private int amount;
    private PatchedDataComponentMap components = new PatchedDataComponentMap(PatchedDataComponentMap.EMPTY);
    public static final Codec<FluidInstance> CODEC = RecordCodecBuilder.create((T i) -> i.group((App)BuiltInRegistries.FLUID.byNameCodec().fieldOf("fluid").forGetter(FluidInstance::getFluid), (App)Codec.INT.fieldOf("amount").forGetter(FluidInstance::getAmount), (App)DataComponentPatch.CODEC.fieldOf("components").forGetter(FluidInstance::getComponentsPatch)).apply((Applicative)i, FluidInstance::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidInstance> STREAM_CODEC = StreamCodec.of(FluidInstance::encode, FluidInstance::decode);
    public static final FluidInstance EMPTY = new FluidInstance(Fluids.EMPTY, 0);
    private FluidStack stack;

    public FluidInstance(Fluid fluid, int amount) {
        this.fluid = fluid;
        this.amount = amount;
    }

    public FluidInstance(Fluid fluid, int amount, DataComponentPatch components) {
        this(fluid, amount);
        this.components = PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.builder().build(), (DataComponentPatch)components);
    }

    public static FluidInstance empty() {
        return EMPTY;
    }

    public static FluidInstance create(FluidInstance fluidInstance, int amount) {
        return FluidInstance.create(fluidInstance.getFluid(), amount);
    }

    public static FluidInstance create(Fluid fluid, int amount) {
        return new FluidInstance(fluid, amount);
    }

    public static FluidInstance create(Fluid fluid) {
        return new FluidInstance(fluid, 1000);
    }

    public static FluidInstance create(Fluid fluid, long amount) {
        return new FluidInstance(fluid, FluidInstance.getMilliBucketsFluidAmount(amount));
    }

    public DataComponentMap getComponents() {
        return this.components;
    }

    public DataComponentPatch getComponentsPatch() {
        return !this.isEmpty() ? this.components.asPatch() : DataComponentPatch.EMPTY;
    }

    public <T> T set(DataComponentType<T> type, @Nullable T component) {
        return (T)this.components.set(type, component);
    }

    public <T> T remove(DataComponentType<? extends T> type) {
        return (T)this.components.remove(type);
    }

    public void applyComponents(DataComponentPatch patch) {
        this.components.applyPatch(patch);
    }

    public void applyComponents(DataComponentMap components) {
        this.components.setAll(components);
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public boolean isEmpty() {
        return this.getAmount() <= 0;
    }

    public int getAmount() {
        return this.getFluid() == Fluids.EMPTY ? 0 : this.amount;
    }

    public long getPlatformAmount() {
        return FluidInstance.getPlatformFluidAmount(this.getAmount());
    }

    public void setAmount(int amount) {
        if (this.getFluid() != Fluids.EMPTY) {
            this.amount = amount;
        }
    }

    public FluidStack toStack() {
        if (this.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (this.stack == null) {
            this.stack = new FluidStack(this.fluid, this.amount);
        }
        this.stack.setAmount(this.amount);
        this.stack.applyComponents(this.getComponents());
        return this.stack;
    }

    public void setAmount(long amount) {
        this.setAmount(FluidInstance.getMilliBucketsFluidAmount(amount));
    }

    public static FluidInstance fromJson(JsonObject jsonObject) {
        if (jsonObject != null) {
            return CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).result().orElse(FluidInstance.empty());
        }
        return FluidInstance.empty();
    }

    public static FluidInstance fromTag(CompoundTag tag) {
        return CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).result().orElseGet(() -> {
            Optional<String> fluidId = CompoundTagUtil.getString(tag, "FluidName");
            if (fluidId.isPresent()) {
                Fluid fluid = (Fluid)FactoryAPIPlatform.getRegistryValue(FactoryAPI.createLocation(fluidId.get()), BuiltInRegistries.FLUID);
                if (fluid == Fluids.EMPTY) {
                    return FluidInstance.empty();
                }
                return FluidInstance.create(fluid, FluidInstance.getMilliBucketsFluidAmount(CompoundTagUtil.getLong(tag, "Amount").orElse(0L)));
            }
            return FluidInstance.empty();
        });
    }

    public static CompoundTag toTag(FluidInstance stack) {
        return CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)stack).result().map(t -> {
            CompoundTag c;
            return t instanceof CompoundTag ? (c = (CompoundTag)t) : null;
        }).orElse(new CompoundTag());
    }

    public static long getPlatformBucketFluidAmount() {
        return FactoryAPI.getLoader().isFabric() ? 81000L : 1000L;
    }

    public static long getPlatformFluidAmount(int amount) {
        return (long)((float)amount / 1000.0f * (float)FluidInstance.getPlatformBucketFluidAmount());
    }

    public static int getMilliBucketsFluidAmount(long amount) {
        return (int)((float)amount / (float)FluidInstance.getPlatformBucketFluidAmount() * 1000.0f);
    }

    public boolean isFluidEqual(FluidInstance resource) {
        return this.getFluid() == resource.getFluid();
    }

    public void grow(int amount) {
        this.setAmount(this.getAmount() + amount);
    }

    public void shrink(int amount) {
        this.setAmount(this.getAmount() - amount);
    }

    public FluidInstance withAmount(int amount) {
        this.setAmount(amount);
        return this;
    }

    public FluidInstance copy() {
        return new FluidInstance(this.getFluid(), this.getAmount());
    }

    public FluidInstance copyWithAmount(int maxDrain) {
        return this.copy().withAmount(maxDrain);
    }

    public Component getName() {
        return this.getFluid().defaultFluidState().createLegacyBlock().getBlock().getName();
    }

    public boolean equals(Object obj) {
        FluidInstance i;
        return super.equals(obj) || obj instanceof FluidInstance && (i = (FluidInstance)obj).isFluidEqual(this) && i.getAmount() == this.getAmount() && this.components.equals((Object)i.components);
    }

    public int hashCode() {
        return Objects.hash(this.fluid, this.amount, this.components);
    }

    public static void encode(RegistryFriendlyByteBuf buf, FluidInstance instance) {
        buf.writeInt(instance.getAmount());
        if (instance.isEmpty()) {
            return;
        }
        buf.writeResourceLocation(BuiltInRegistries.FLUID.getKey((Object)instance.getFluid()));
        DataComponentPatch.STREAM_CODEC.encode((Object)buf, (Object)instance.getComponentsPatch());
    }

    public static FluidInstance decode(RegistryFriendlyByteBuf buf) {
        int amount = buf.readInt();
        if (amount <= 0) {
            return EMPTY;
        }
        return new FluidInstance((Fluid)FactoryAPIPlatform.getRegistryValue(buf.readResourceLocation(), BuiltInRegistries.FLUID), amount, (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode((Object)buf));
    }
}

