/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.util.FluidInstance;

public interface ItemContainerPlatform {
    public static boolean isBlockItem(ItemStack s) {
        return s.m_41720_() instanceof BlockItem;
    }

    public static Fluid getBucketFluid(BucketItem item) {
        return item.getFluid();
    }

    public static boolean isFluidContainer(ItemStack stack) {
        return !stack.m_41619_() && ItemContainerPlatform.getItemFluidHandler(stack) != null;
    }

    public static boolean isEnergyContainer(ItemStack stack) {
        return !stack.m_41619_() && ItemContainerPlatform.getItemEnergyStorage(stack) != null;
    }

    public static FluidInstance getFluid(ItemStack stack) {
        return ItemContainerPlatform.isFluidContainer(stack) ? FactoryAPIPlatform.fluidStackToInstance(ItemContainerPlatform.getItemFluidHandler(stack).getFluidInTank(0)) : FluidInstance.empty();
    }

    public static FluidInstance getFluid(Player player, InteractionHand hand) {
        return ItemContainerPlatform.getFluid(player.m_21120_(hand));
    }

    public static int fillItem(FluidInstance fluidInstance, Player player, InteractionHand hand) {
        return ItemContainerPlatform.fillItem(player.m_21120_(hand), player, hand, fluidInstance).fluidInstance().getAmount();
    }

    public static ItemFluidContext fillItem(ItemStack stack, FluidInstance fluidInstance) {
        return ItemContainerPlatform.fillItem(stack, null, null, fluidInstance);
    }

    public static FluidInstance drainItem(int maxDrain, Player player, InteractionHand hand) {
        return ItemContainerPlatform.drainItem(maxDrain, player.m_21120_(hand), player, hand).fluidInstance();
    }

    public static ItemFluidContext drainItem(int maxDrain, ItemStack stack) {
        return ItemContainerPlatform.drainItem(maxDrain, stack, null, null);
    }

    public static int insertEnergy(int energy, Player player, InteractionHand hand) {
        return ItemContainerPlatform.insertEnergy(energy, player.m_21120_(hand)).contextEnergy();
    }

    public static ItemEnergyContext insertEnergy(int energy, ItemStack stack) {
        return new ItemEnergyContext(ItemContainerPlatform.getItemEnergyStorage(stack).receiveEnergy(energy, false), stack);
    }

    public static int extractEnergy(int energy, Player player, InteractionHand hand) {
        return ItemContainerPlatform.extractEnergy(energy, player.m_21120_(hand)).contextEnergy();
    }

    public static ItemEnergyContext extractEnergy(int energy, ItemStack stack) {
        return new ItemEnergyContext(ItemContainerPlatform.getItemEnergyStorage(stack).extractEnergy(energy, false), stack);
    }

    public static int getEnergy(ItemStack stack) {
        return ItemContainerPlatform.isEnergyContainer(stack) ? 0 : ItemContainerPlatform.getItemEnergyStorage(stack).getEnergyStored();
    }

    public static IFluidHandlerItem getItemFluidHandler(ItemStack stack) {
        return (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
    }

    public static IEnergyStorage getItemEnergyStorage(ItemStack stack) {
        return (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).orElse(null);
    }

    public static ItemFluidContext fillItem(ItemStack stack, Player player, InteractionHand hand, FluidInstance fluidInstance) {
        if (!ItemContainerPlatform.isFluidContainer(stack) || player == null && stack.m_41613_() != 1) {
            return new ItemFluidContext(stack);
        }
        IFluidHandler.FluidAction action = FactoryAPIPlatform.fluidActionOf(player != null && player.m_7500_());
        ItemStack toFill = action.execute() ? stack.m_255036_(1) : stack.m_41777_();
        IFluidHandlerItem tank = ItemContainerPlatform.getItemFluidHandler(toFill);
        int amount = tank.fill(fluidInstance.toStack(), action);
        if (player != null && amount > 0) {
            SoundEvent sound;
            if (action.execute()) {
                if (stack.m_41613_() > 1) {
                    player.m_21008_(hand, stack.m_255036_(stack.m_41613_() - 1));
                    player.m_36356_(tank.getContainer());
                } else {
                    player.m_21008_(hand, tank.getContainer());
                }
            }
            if ((sound = fluidInstance.getFluid().getFluidType().getSound(fluidInstance.toStack(), SoundActions.BUCKET_FILL)) != null) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), sound, SoundSource.PLAYERS, 0.6f, 0.8f);
            }
        }
        return new ItemFluidContext(FluidInstance.create(fluidInstance.getFluid(), amount), tank.getContainer());
    }

    public static ItemFluidContext drainItem(int maxDrain, ItemStack stack, Player player, InteractionHand hand) {
        if (!ItemContainerPlatform.isFluidContainer(stack) || player == null && stack.m_41613_() != 1) {
            return new ItemFluidContext(stack);
        }
        IFluidHandler.FluidAction action = FactoryAPIPlatform.fluidActionOf(player != null && player.m_7500_());
        ItemStack toDrain = action.execute() ? stack.m_255036_(1) : stack.m_41777_();
        IFluidHandlerItem tank = ItemContainerPlatform.getItemFluidHandler(toDrain);
        FluidStack fluidStack = tank.drain(maxDrain, action);
        if (player != null && fluidStack.getAmount() > 0) {
            SoundEvent sound;
            if (action.execute()) {
                if (stack.m_41613_() > 1) {
                    player.m_21008_(hand, stack.m_255036_(stack.m_41613_() - 1));
                    player.m_36356_(tank.getContainer());
                } else {
                    player.m_21008_(hand, tank.getContainer());
                }
            }
            if ((sound = fluidStack.getFluid().getFluidType().getSound(fluidStack, SoundActions.BUCKET_EMPTY)) != null) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), sound, SoundSource.PLAYERS, 0.6f, 0.8f);
            }
        }
        return new ItemFluidContext(FluidInstance.create(fluidStack.getFluid(), fluidStack.getAmount()), tank.getContainer());
    }

    public record ItemFluidContext(FluidInstance fluidInstance, ItemStack container) {
        public ItemFluidContext(ItemStack container) {
            this(FluidInstance.empty(), container);
        }
    }

    public record ItemEnergyContext(int contextEnergy, ItemStack container) {
        public ItemEnergyContext(ItemStack container) {
            this(0, container);
        }
    }
}

