/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.IFactoryExpandedStorage;
import wily.factoryapi.base.Progress;

public interface IFactoryProgressiveStorage
extends IFactoryExpandedStorage {
    default public boolean hasProgress() {
        return !this.getProgresses().isEmpty();
    }

    default public List<Progress> getProgresses() {
        return Collections.emptyList();
    }

    @Nullable
    default public Progress getProgressByType(Progress.Identifier identifier) {
        for (Progress p : this.getProgresses()) {
            if (p.identifier != identifier) continue;
            return p;
        }
        return null;
    }

    @Override
    default public void loadTag(CompoundTag compoundTag) {
        IFactoryExpandedStorage.super.loadTag(compoundTag);
        if (this.hasProgress()) {
            this.getProgresses().forEach(p -> p.deserializeTag(compoundTag));
        }
    }

    @Override
    default public void saveTag(CompoundTag compoundTag) {
        IFactoryExpandedStorage.super.saveTag(compoundTag);
        if (this.hasProgress()) {
            this.getProgresses().forEach(p -> compoundTag.m_128391_(p.serializeTag()));
        }
    }
}

