/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import wily.factoryapi.base.CraftyTransaction;
import wily.factoryapi.base.FactoryCapacityTier;
import wily.factoryapi.base.ICraftyEnergyStorage;
import wily.factoryapi.base.TransportState;

public class SimpleItemCraftyStorage
implements ICraftyEnergyStorage {
    private static final String KEY = "energy";
    private int capacity;
    private final int maxOutput;
    private final int maxInput;
    ItemStack container;
    TransportState transportState;
    final boolean isBlockItem;
    public final FactoryCapacityTier supportableTier;
    public FactoryCapacityTier storedTier = FactoryCapacityTier.BASIC;

    public SimpleItemCraftyStorage(ItemStack stack, int initialEnergy, int capacity, int maxOutput, int maxInput, TransportState transportState, FactoryCapacityTier supportableTier, boolean isBlockItem) {
        this.supportableTier = supportableTier;
        this.isBlockItem = isBlockItem;
        this.capacity = capacity;
        this.container = stack;
        CompoundTag tag = stack.m_41784_();
        if (isBlockItem) {
            tag = tag.m_128469_("BlockEntityTag");
        }
        if (tag.m_128469_("CYEnergy").m_128456_()) {
            CompoundTag storage = new CompoundTag();
            storage.m_128405_(KEY, initialEnergy);
            storage.m_128405_("supportedTier", supportableTier.ordinal());
            storage.m_128405_("tier", this.storedTier.ordinal());
            tag.m_128365_("CYEnergy", (Tag)storage);
            if (isBlockItem) {
                stack.m_41784_().m_128365_("BlockEntityTag", (Tag)tag);
            }
        }
        this.transportState = transportState;
        this.maxOutput = maxOutput;
        this.maxInput = maxInput;
    }

    public SimpleItemCraftyStorage(ItemStack stack, int capacity, TransportState transportState, FactoryCapacityTier supportableTier) {
        this(stack, 0, capacity, capacity, capacity, transportState, supportableTier, stack.m_41720_() instanceof BlockItem);
    }

    private CompoundTag getEnergyCompound() {
        CompoundTag tag = this.container.m_41784_();
        if (this.isBlockItem) {
            tag = tag.m_128469_("BlockEntityTag");
        }
        return tag.m_128469_("CYEnergy");
    }

    @Override
    public CraftyTransaction receiveEnergy(CraftyTransaction transaction, boolean simulate) {
        if (transaction.isEmpty()) {
            return CraftyTransaction.EMPTY;
        }
        int energyReceived = Math.min(this.getMaxReceive(), transaction.energy);
        int energy = this.getEnergyStored();
        if (!simulate) {
            if (!this.supportableTier.supportTier(transaction.tier)) {
                return CraftyTransaction.EMPTY;
            }
            this.setStoredTier(transaction.tier);
            this.setEnergyStored(energy += energyReceived);
        }
        return new CraftyTransaction(energyReceived, transaction.tier);
    }

    @Override
    public CraftyTransaction consumeEnergy(CraftyTransaction transaction, boolean simulate) {
        if (transaction.isEmpty()) {
            return CraftyTransaction.EMPTY;
        }
        int energy = this.getEnergyStored();
        int energyExtracted = Math.min(energy, Math.min(this.getMaxConsume(), transaction.energy));
        if (!simulate) {
            if (!this.storedTier.supportTier(transaction.tier)) {
                energyExtracted = this.storedTier.convertEnergyTo(energyExtracted, transaction.tier);
            }
            this.setEnergyStored(energy -= energyExtracted);
        }
        return new CraftyTransaction(energyExtracted, transaction.tier);
    }

    @Override
    public FactoryCapacityTier getSupportedTier() {
        return FactoryCapacityTier.values()[this.getEnergyCompound().m_128451_("tier")];
    }

    @Override
    public FactoryCapacityTier getStoredTier() {
        return FactoryCapacityTier.values()[this.getEnergyCompound().m_128451_("tier")];
    }

    @Override
    public int getEnergyStored() {
        return this.getEnergyCompound().m_128451_(KEY);
    }

    @Override
    public void setEnergyStored(int energy) {
        CompoundTag tag = this.getEnergyCompound();
        tag.m_128405_(KEY, energy);
    }

    @Override
    public void setStoredTier(FactoryCapacityTier tier) {
        CompoundTag tag = this.getEnergyCompound();
        tag.m_128405_("tier", tier.ordinal());
    }

    @Override
    public void setSupportedTier(FactoryCapacityTier tier) {
        CompoundTag tag = this.getEnergyCompound();
        tag.m_128405_("supportedTier", tier.ordinal());
    }

    @Override
    public int getMaxEnergyStored() {
        return this.capacity;
    }

    @Override
    public CompoundTag serializeTag() {
        return this.getEnergyCompound();
    }

    @Override
    public void deserializeTag(CompoundTag nbt) {
        this.container.m_41751_(nbt);
    }

    @Override
    public int getMaxConsume() {
        return Math.min(this.getEnergyStored(), this.maxOutput);
    }

    @Override
    public int getMaxReceive() {
        return Math.min(this.getEnergySpace(), this.maxInput);
    }

    @Override
    public TransportState getTransport() {
        return this.transportState;
    }
}

