/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.FactoryIngredient;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.FactoryItemUtil;

public class StackIngredient
extends Ingredient
implements FactoryIngredient {
    public static final MapCodec<StackIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)HolderSetCodec.m_206685_((ResourceKey)Registries.f_256913_, (Codec)BuiltInRegistries.f_257033_.m_206110_(), (boolean)false).fieldOf("items").forGetter(StackIngredient::values), (App)CompoundTag.f_128325_.fieldOf("nbt").forGetter(StackIngredient::getTag), (App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter(StackIngredient::isStrict), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(StackIngredient::getCount)).apply((Applicative)builder, StackIngredient::new));
    public static final CommonNetwork.Identifier<StackIngredient> ID = CommonNetwork.Identifier.create(FactoryAPI.createModLocation("stack_ingredient"), StackIngredient::decode);
    private final HolderSet<Item> values;
    private final CompoundTag tag;
    private final boolean strict;
    protected final ItemStack[] stacks;
    private final int count;

    public StackIngredient(HolderSet<Item> values, CompoundTag tag, boolean strict, int count) {
        super(Stream.empty());
        this.values = values;
        this.tag = tag;
        this.strict = strict;
        this.stacks = (ItemStack[])values.m_203614_().map(i -> {
            ItemStack stack = new ItemStack(i, count);
            stack.m_41751_(tag);
            return stack;
        }).filter(i -> !i.m_41619_()).toArray(ItemStack[]::new);
        this.count = count;
    }

    @Override
    public boolean test(ItemStack stack) {
        if (this.strict) {
            for (ItemStack stack2 : this.stacks) {
                if (!FactoryItemUtil.equalItems(stack, stack2)) continue;
                return true;
            }
            return false;
        }
        return this.values.m_203333_(stack.m_220173_()) && NbtUtils.m_129235_((Tag)this.tag, (Tag)stack.m_41783_(), (boolean)true);
    }

    public boolean m_43947_() {
        return this.stacks.length == 0;
    }

    public ItemStack[] m_43908_() {
        return this.stacks;
    }

    public HolderSet<Item> values() {
        return this.values;
    }

    @Override
    public ItemStack[] getStacks() {
        return this.stacks;
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public static StackIngredient of(boolean strict, ItemStack stack) {
        return StackIngredient.of(strict, stack, stack.m_41613_());
    }

    public static StackIngredient of(boolean strict, ItemStack stack, int count) {
        return new StackIngredient((HolderSet<Item>)HolderSet.m_205809_((Holder[])new Holder[]{stack.m_220173_()}), stack.m_41783_(), strict, count);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
        return ID;
    }

    @Override
    public void encode(CommonNetwork.PlayBuf buf) {
        ((FriendlyByteBuf)buf.get()).m_236828_(this.values.m_203614_().toList(), (b, i) -> b.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)((Item)i.m_203334_())));
        ((FriendlyByteBuf)buf.get()).m_130079_((Tag)this.tag);
        ((FriendlyByteBuf)buf.get()).writeBoolean(this.isStrict());
        ((FriendlyByteBuf)buf.get()).writeByte(this.getCount());
    }

    public static StackIngredient decode(CommonNetwork.PlayBuf buf) {
        return new StackIngredient((HolderSet<Item>)HolderSet.m_205800_((List)((List)((FriendlyByteBuf)buf.get()).m_236838_(ArrayList::new, b -> (Holder)b.m_236816_(BuiltInRegistries.f_257033_.m_206115_())))), ((FriendlyByteBuf)buf.get()).m_130260_(), ((FriendlyByteBuf)buf.get()).readBoolean(), ((FriendlyByteBuf)buf.get()).readByte());
    }
}

