/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.mixin.base.FontAccessor;
import wily.factoryapi.util.FactoryScreenUtil;

public class AdvancedTextWidget
extends SimpleLayoutRenderable
implements GuiEventListener,
NarratableEntry {
    private final UIAccessor accessor;
    private List<FormattedCharSequence> lines = Collections.emptyList();
    private int[] widthPerLine = new int[0];
    private int[] heightPerLine = new int[0];
    private int lineSpacing = 12;
    private boolean centered = false;
    private int color = -1;
    private boolean shadow = true;
    private boolean multipleHeights = true;

    public AdvancedTextWidget(UIAccessor accessor) {
        this.accessor = accessor;
    }

    public AdvancedTextWidget withLines(List<FormattedCharSequence> lines) {
        if (lines != null) {
            this.lines = lines;
            this.processLines();
        }
        return this;
    }

    public void processLines() {
        this.height = 0;
        this.widthPerLine = new int[this.lines.size()];
        this.heightPerLine = new int[this.lines.size()];
        for (int i = 0; i < this.lines.size(); ++i) {
            FormattedCharSequence sequence = this.lines.get(i);
            this.widthPerLine[i] = Minecraft.m_91087_().f_91062_.m_92724_(sequence);
            this.heightPerLine[i] = this.multipleHeights ? Math.max(this.lineSpacing, Math.max(AdvancedTextWidget.getLineHeight(sequence) - 9, 0) + this.lineSpacing) : this.lineSpacing;
            this.height += this.heightPerLine[i];
        }
    }

    public AdvancedTextWidget withLines(Component component, int width) {
        return this.withWidth(width).withLines(Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)component, width));
    }

    public static int getLineHeight(FormattedCharSequence sequence) {
        Bearer<Integer> bearer = Bearer.of(0);
        sequence.m_13731_((n, style, pos) -> {
            FontAccessor fontAccessor = (FontAccessor)Minecraft.m_91087_().f_91062_;
            fontAccessor.getDefaultFontSet(style.m_131192_()).m_243128_(pos, fontAccessor.getFilterFishyGlyphs()).m_213604_(sheetGlyphInfo -> {
                int height = Math.round((float)sheetGlyphInfo.m_213961_() / sheetGlyphInfo.m_213963_());
                if (height > (Integer)bearer.get()) {
                    bearer.set(height);
                }
                return null;
            });
            return true;
        });
        return (Integer)bearer.get();
    }

    public AdvancedTextWidget lineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
        return this;
    }

    public AdvancedTextWidget centered(boolean centered) {
        this.centered = centered;
        return this;
    }

    public AdvancedTextWidget multipleHeights(boolean multipleHeights) {
        this.multipleHeights = multipleHeights;
        return this;
    }

    public AdvancedTextWidget withPos(int x, int y) {
        this.m_264152_(x, y);
        return this;
    }

    public AdvancedTextWidget withWidth(int width) {
        this.width = width;
        return this;
    }

    public AdvancedTextWidget withColor(int color) {
        this.color = color;
        return this;
    }

    public AdvancedTextWidget withShadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public List<FormattedCharSequence> getLines() {
        return this.lines;
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        int actualHeight = this.m_252907_();
        for (int i1 = 0; i1 < this.lines.size(); ++i1) {
            int lineHeight = this.heightPerLine[i1];
            guiGraphics.m_280649_(Minecraft.m_91087_().f_91062_, this.lines.get(i1), this.m_252754_() + (this.centered ? (this.width - this.widthPerLine[i1]) / 2 : 0), actualHeight + (lineHeight - this.lineSpacing) / 2, this.color, this.shadow);
            actualHeight += lineHeight;
        }
    }

    public boolean m_6375_(double d, double e, int i) {
        if (this.handleComponentsClicked(d, e, i)) {
            return true;
        }
        return super.m_6375_(d, e, i);
    }

    public boolean handleComponentsClicked(double d, double e, int i) {
        if (this.accessor.getScreen() != null && this.m_5953_(d, e)) {
            if (i == 0) {
                int actualHeight = this.m_252907_();
                for (int i1 = 0; i1 < this.lines.size(); ++i1) {
                    int lineHeight = this.heightPerLine[i1];
                    if (e >= (double)actualHeight && e < (double)(actualHeight + lineHeight)) {
                        this.accessor.getScreen().m_5561_(Minecraft.m_91087_().f_91062_.m_92865_().m_92338_(this.lines.get(i1), Mth.m_14107_((double)(d - (double)this.m_252754_()))));
                        return true;
                    }
                    actualHeight += lineHeight;
                }
            }
            return false;
        }
        return false;
    }

    public boolean m_5953_(double d, double e) {
        return FactoryScreenUtil.isMouseOver(d, e, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_());
    }

    public void m_93692_(boolean bl) {
    }

    public boolean m_93696_() {
        return false;
    }

    public ScreenRectangle m_264198_() {
        return super.m_264198_();
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput arg) {
    }
}

