/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client.drawable;

import java.awt.Color;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.drawable.DrawableCustomWidth;
import wily.factoryapi.base.client.drawable.IFactoryDrawableType;
import wily.factoryapi.util.FactoryScreenUtil;

public abstract class AbstractDrawableButton<D extends AbstractDrawableButton<D>>
extends DrawableCustomWidth<D>
implements GuiEventListener {
    @Nullable
    public Boolean selected;
    protected BiConsumer<D, Integer> onPress = (b, i) -> {};
    public IFactoryDrawableType selection;
    protected boolean hoverSelection = true;
    public Color color;
    public float grave = 1.5f;

    public AbstractDrawableButton(int x, int y, IFactoryDrawableType buttonImage) {
        super(buttonImage, x, y);
    }

    public D onPress(BiConsumer<D, Integer> onPress) {
        this.onPress = onPress;
        return (D)this;
    }

    public D grave(float grave) {
        this.grave = grave;
        return (D)this;
    }

    public D color(Color color) {
        this.color = color;
        return (D)this;
    }

    public D icon(IFactoryDrawableType icon) {
        return (D)((AbstractDrawableButton)this.overlay(icon));
    }

    public D select(Boolean selected) {
        this.selected = selected;
        return (D)this;
    }

    public D selection(IFactoryDrawableType selection) {
        this.selection = selection;
        return (D)this;
    }

    public D selection(IFactoryDrawableType.Direction direction) {
        return this.selection(this.adjacentImage(direction));
    }

    public D withWidth(Integer width) {
        this.customWidth = width != null ? Integer.valueOf(Math.max(4, width)) : null;
        return (D)this;
    }

    public D disableHoverSelection() {
        this.hoverSelection = false;
        return (D)this;
    }

    public boolean m_5953_(double d, double e) {
        return this.inMouseLimit(d, e);
    }

    public boolean m_6375_(double d, double e, int i) {
        return this.handleClick(d, e, i);
    }

    public boolean m_6348_(double d, double e, int i) {
        return this.handleRelease(d, e, i);
    }

    public boolean m_7979_(double mouseX, double mouseY, int i, double f, double g) {
        return this.handleDragging(mouseX, mouseY, i, f, g);
    }

    public boolean handleClick(double d, double e, int i) {
        if (this.inMouseLimit(d, e) && ((Boolean)this.visible.get()).booleanValue()) {
            FactoryScreenUtil.playButtonDownSound(this.grave);
            if (this.selected != null) {
                this.selected = this.selected == false;
            }
            this.onPress.accept(this, i);
            return true;
        }
        return false;
    }

    public boolean handleRelease(double d, double e, int i) {
        return false;
    }

    public boolean handleDragging(double mouseX, double mouseY, int i, double dx, double dy) {
        return false;
    }

    @Override
    public boolean inMouseLimit(double mouseX, double mouseY) {
        return FactoryScreenUtil.isMouseOver(mouseX, mouseY, this.m_110085_(), this.m_110086_(), this.width(), this.height());
    }

    @Override
    public void draw(GuiGraphics graphics) {
        this.draw(graphics, this.m_110085_(), this.m_110086_());
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y) {
        if (this.color != null) {
            FactoryGuiGraphics.of(graphics).setColor((float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f, 1.0f);
        }
        super.draw(graphics, x, y);
        if (this.color != null) {
            FactoryGuiGraphics.of(graphics).clearColor();
        }
        if (this.isSelected() || this.hovered && this.hoverSelection) {
            if (this.selection != null) {
                this.selection.draw(graphics, x, y);
            } else {
                graphics.m_280637_(x, y, this.width(), this.height(), -1);
            }
        }
    }

    public ScreenRectangle m_264198_() {
        return FactoryScreenUtil.rect2iToRectangle(this);
    }

    public boolean isSelected() {
        return this.selected == Boolean.TRUE;
    }

    public void m_93692_(boolean bl) {
        if (bl) {
            this.selected = true;
        }
    }

    public boolean m_93696_() {
        return false;
    }
}

