/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client.screen;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.client.FactoryConfigWidgets;
import wily.factoryapi.base.client.FactoryOptions;
import wily.factoryapi.base.config.FactoryCommonOptions;
import wily.factoryapi.base.config.FactoryConfig;

public class FactoryConfigScreen
extends Screen {
    public static final Component TITLE = Component.m_237115_((String)"options.factory_api.title");
    protected final List<AbstractWidget> optionWidgets = new ArrayList<AbstractWidget>();
    public static final List<FactoryConfig<?>> CONFIGS = new ArrayList<FactoryConfig<Boolean>>(List.of(FactoryOptions.NEAREST_MIPMAP_SCALING, FactoryOptions.RANDOM_BLOCK_ROTATIONS, FactoryOptions.MANUAL_MIPMAP, FactoryOptions.UI_DEFINITION_LOGGING, FactoryCommonOptions.EXPRESSION_FAIL_LOGGING));
    public final Screen parent;
    private ConfigList list;

    public FactoryConfigScreen(Screen screen, List<FactoryConfig<?>> configs, Component title) {
        super(title);
        this.parent = screen;
        for (FactoryConfig<?> config : configs) {
            AbstractWidget widget;
            if (config.getStorageAccess().allowSync() && !config.getStorageAccess().allowClientSync((Player)Minecraft.m_91087_().f_91074_) || (widget = FactoryConfigWidgets.createWidget(config, 0, 0, 150, b -> config.sync())) == null) continue;
            this.optionWidgets.add(widget);
        }
    }

    public static FactoryConfigScreen createFactoryAPIConfigScreen(Screen parent) {
        return new FactoryConfigScreen(parent, CONFIGS, TITLE);
    }

    protected void m_7856_() {
        this.list = (ConfigList)this.m_142416_((GuiEventListener)new ConfigList(this.f_96541_, this.f_96543_, this.f_96544_ - 64, 32, 25, this));
        this.list.addSmall(this.optionWidgets);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 27, 200, 20).m_253136_());
        super.m_7856_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        super.m_88315_(guiGraphics, i, j, f);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public static class ConfigList
    extends ContainerObjectSelectionList<Entry> {
        private final Screen screen;

        public ConfigList(Minecraft minecraft, int screenWidth, int listHeight, int k, int l, Screen screen) {
            super(minecraft, screenWidth, listHeight, k, l);
            this.screen = screen;
        }

        public void addSmall(List<AbstractWidget> list) {
            for (int i = 0; i < list.size(); i += 2) {
                this.addSmall(list.get(i), i < list.size() - 1 ? list.get(i + 1) : null);
            }
        }

        public void addSmall(AbstractWidget arg, @Nullable AbstractWidget arg2) {
            this.m_7085_((AbstractSelectionList.Entry)Entry.small(arg, arg2, this.screen));
        }

        public int m_5759_() {
            return 310;
        }

        public static class Entry
        extends ContainerObjectSelectionList.Entry<Entry> {
            private final List<AbstractWidget> children;
            private final Screen screen;

            Entry(List<AbstractWidget> list, Screen arg) {
                this.children = ImmutableList.copyOf(list);
                this.screen = arg;
            }

            public static Entry big(List<AbstractWidget> list, Screen arg) {
                return new Entry(list, arg);
            }

            public static Entry small(AbstractWidget arg, @Nullable AbstractWidget arg2, Screen arg3) {
                return arg2 == null ? new Entry((List<AbstractWidget>)ImmutableList.of((Object)arg), arg3) : new Entry((List<AbstractWidget>)ImmutableList.of((Object)arg, (Object)arg2), arg3);
            }

            public void m_6311_(GuiGraphics arg, int i, int j, int k, int l, int m, int n, int o, boolean bl, float f) {
                this.renderContent(arg, n, o, bl, f, j);
            }

            public void renderContent(GuiGraphics guiGraphics, int i, int j, boolean bl, float f, int contentY) {
                int p = 0;
                int q = this.screen.f_96543_ / 2 - 155;
                for (AbstractWidget abstractWidget : this.children) {
                    abstractWidget.m_264152_(q + p, contentY);
                    abstractWidget.m_88315_(guiGraphics, i, j, f);
                    p += 160;
                }
            }

            public List<? extends GuiEventListener> m_6702_() {
                return this.children;
            }

            public List<? extends NarratableEntry> m_142437_() {
                return this.children;
            }
        }
    }
}

