/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.network;

import java.util.Collection;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.mixin.base.RecipeManagerAccessor;

public class CommonRecipeManager {
    public static <R extends Recipe<?>> RecipeHolder<R> byId(ResourceLocation id, RecipeType<R> type) {
        return CommonRecipeManager.getRecipeManager().m_44043_(id).orElse(null);
    }

    public static <R extends Recipe<?>> Collection<RecipeHolder<R>> byType(RecipeType<R> type) {
        return ((RecipeManagerAccessor)CommonRecipeManager.getRecipeManager()).getRecipeByType(type).values();
    }

    public static <R extends Recipe<I>, I extends Container> Optional<RecipeHolder<R>> getRecipeFor(RecipeType<R> type, I input, Level level) {
        Collection<RecipeHolder<R>> recipes = CommonRecipeManager.byType(type);
        for (RecipeHolder<R> recipe : recipes) {
            if (!recipe.f_291008_().m_5818_(input, level)) continue;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    public static <R extends Recipe<I>, I extends Container> Optional<ItemStack> getResultFor(RecipeType<R> type, I input, Level level) {
        return CommonRecipeManager.getRecipeFor(type, input, level).map(r -> r.f_291008_().m_5874_(input, level.m_9598_()));
    }

    public static RecipeManager getRecipeManager() {
        return FactoryAPI.currentServer == null ? FactoryAPIClient.getRecipeManager() : FactoryAPI.currentServer.m_129894_();
    }
}

