/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.network;

import com.google.gson.JsonElement;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.client.UIDefinitionManager;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.base.network.CommonNetwork;

public class FactoryAPICommand {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher, CommandBuildContext commandBuildContext) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"factoryapi").requires(commandSourceStack -> commandSourceStack.m_6761_(2));
        command.then(Commands.m_82127_((String)"display").then(Commands.m_82127_((String)"ui_definition").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"ui_definition", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> {
            CommonNetwork.sendToPlayers(EntityArgument.m_91477_((CommandContext)context, (String)"targets"), new UIDefinitionPayload(Optional.empty(), CompoundTagArgument.m_87660_((CommandContext)context, (String)"ui_definition")));
            return 0;
        })).then(Commands.m_82129_((String)"default_screen", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(context -> {
            CommonNetwork.sendToPlayers(EntityArgument.m_91477_((CommandContext)context, (String)"targets"), new UIDefinitionPayload(Optional.of(ResourceLocationArgument.m_107011_((CommandContext)context, (String)"default_screen")), CompoundTagArgument.m_87660_((CommandContext)context, (String)"ui_definition")));
            return 0;
        }))))));
        LiteralArgumentBuilder config = Commands.m_82127_((String)"config");
        FactoryConfig.COMMON_STORAGES.forEach((k, s) -> config.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)k.toString()).then(Commands.m_82127_((String)"reload").executes(c -> {
            s.load();
            return 1;
        }))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"value", (ArgumentType)CompoundTagArgument.m_87657_()).executes(c -> {
            s.decodeConfigs(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)CompoundTagArgument.m_87660_((CommandContext)c, (String)"value")));
            s.sync();
            return 1;
        })))).then(Commands.m_82127_((String)"save").executes(c -> {
            s.save();
            return 1;
        }))));
        command.then((ArgumentBuilder)config);
        commandDispatcher.register(command);
    }

    public record UIDefinitionPayload(Optional<ResourceLocation> defaultScreen, CompoundTag uiDefinitionNbt) implements CommonNetwork.Payload
    {
        public static final CommonNetwork.Identifier<UIDefinitionPayload> ID = CommonNetwork.Identifier.create(FactoryAPI.createModLocation("ui_definition_s2c"), UIDefinitionPayload::decode);

        @Override
        public void apply(CommonNetwork.Payload.Context context) {
            context.executor().execute(() -> FactoryAPIClient.uiDefinitionManager.openDefaultScreenAndAddDefinition(this.defaultScreen, UIDefinitionManager.fromDynamic(ID.toString(), new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)this.uiDefinitionNbt))));
        }

        public static UIDefinitionPayload decode(CommonNetwork.PlayBuf buf) {
            return new UIDefinitionPayload(((FriendlyByteBuf)buf.get()).m_236860_(FriendlyByteBuf::m_130281_), ((FriendlyByteBuf)buf.get()).m_130260_());
        }

        @Override
        public void encode(CommonNetwork.PlayBuf buf) {
            ((FriendlyByteBuf)buf.get()).m_236835_(this.defaultScreen, FriendlyByteBuf::m_130085_);
            ((FriendlyByteBuf)buf.get()).m_130079_((Tag)this.uiDefinitionNbt);
        }

        public CommonNetwork.Identifier<UIDefinitionPayload> identifier() {
            return ID;
        }
    }

    public static class JsonArgument
    implements ArgumentType<JsonElement> {
        public static final Map<String, Field> JSON_READER_FIELDS = FactoryAPI.getAccessibleFieldsMap(JsonReader.class, "pos", "lineStart");
        private static final Collection<String> EXAMPLES = Arrays.asList("\"hello world\"", "\"\"", "\"{\"text\":\"hello world\"}", "[\"\"]");

        public static int getPos(JsonReader jsonReader) {
            try {
                return JSON_READER_FIELDS.get("pos").getInt(jsonReader) - JSON_READER_FIELDS.get("lineStart").getInt(jsonReader) + 1;
            }
            catch (IllegalAccessException var2) {
                throw new IllegalStateException("Couldn't read position of JsonReader", var2);
            }
        }

        public static JsonElement getJson(CommandContext<CommandSourceStack> commandContext, String string) {
            return (JsonElement)commandContext.getArgument(string, JsonElement.class);
        }

        public static JsonArgument json() {
            return new JsonArgument();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JsonElement parse(com.mojang.brigadier.StringReader stringReader) {
            JsonElement element;
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(stringReader.getRemaining()));
            jsonReader.setLenient(false);
            try {
                element = Streams.parse((JsonReader)jsonReader);
            }
            finally {
                stringReader.setCursor(stringReader.getCursor() + JsonArgument.getPos(jsonReader));
            }
            return element;
        }

        public Collection<String> getExamples() {
            return EXAMPLES;
        }
    }
}

