/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.mixin.base;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.Map;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.client.FactoryOptions;
import wily.factoryapi.base.client.MipmapMetadataSection;

@Mixin(value={SpriteContents.class})
public abstract class SpriteContentsMixin {
    @Shadow
    NativeImage[] f_243731_;

    @Shadow
    public abstract ResourceMetadata m_293312_();

    @Shadow
    public abstract ResourceLocation m_246162_();

    @Inject(method={"increaseMipLevel"}, at={@At(value="RETURN")})
    public void increaseMipLevel(int i, CallbackInfo ci) {
        if (!((Boolean)FactoryOptions.MANUAL_MIPMAP.get()).booleanValue()) {
            return;
        }
        MipmapMetadataSection manualMipmap = this.m_293312_().m_214059_(MipmapMetadataSection.TYPE).orElseGet(() -> MipmapMetadataSection.createFallback((SpriteContents)this, i));
        NativeImage original = this.f_243731_[0];
        for (Map.Entry<Integer, MipmapMetadataSection.Level> entry : manualMipmap.levels().entrySet()) {
            if (entry.getKey() > i) break;
            NativeImage image = entry.getValue().image();
            int divisor = (int)Math.pow(2.0, entry.getKey().intValue());
            int width = original.m_84982_() / divisor;
            int height = original.m_85084_() / divisor;
            if (image == null) {
                FactoryAPI.LOGGER.error("Failed to replace generated mipmap from texture {}: {} failed to load", (Object)this.m_246162_(), (Object)entry.getValue().texture());
                continue;
            }
            if (image.m_84982_() != width || image.m_85084_() != height) {
                FactoryAPI.LOGGER.error("Failed to replace generated mipmap from texture {}: {} has an incorrect size, it should be {}x{}", (Object)this.m_246162_(), (Object)entry.getValue().texture(), (Object)width, (Object)height);
                continue;
            }
            this.f_243731_[entry.getKey().intValue()] = image;
        }
    }
}

