/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.FactoryGuiMatrixStack;
import wily.factoryapi.base.client.IWindowWidget;
import wily.factoryapi.base.client.drawable.AbstractDrawableButton;
import wily.factoryapi.base.client.drawable.DrawableStatic;
import wily.factoryapi.util.FactoryScreenUtil;

public abstract class FactoryScreenWindow<T extends AbstractContainerScreen<?>>
extends AbstractWidget
implements IWindowWidget {
    public final AbstractDrawableButton<?> config;
    private double actualMouseX;
    private double actualMouseY;
    public boolean dragging = false;
    public ResourceLocation backgroundSprite;
    protected final ItemRenderer itemRenderer;
    protected final Font font;
    protected final List<Renderable> nestedRenderables;
    protected final DrawableStatic drawable;
    public T parent;
    protected int lastX;
    protected int lastY;

    public FactoryScreenWindow(AbstractDrawableButton<?> config, DrawableStatic drawable, T parent) {
        super(drawable.getX(), drawable.getY(), drawable.width(), drawable.height(), (Component)Component.empty());
        this.font = Minecraft.getInstance().font;
        this.nestedRenderables = new ArrayList<Renderable>();
        this.config = config;
        this.lastX = this.getX();
        this.lastY = this.getY();
        this.parent = parent;
        this.drawable = drawable;
        this.itemRenderer = Minecraft.getInstance().getItemRenderer();
    }

    @Override
    public boolean isVisible() {
        return this.config.selected == Boolean.TRUE && (Boolean)this.config.visible.get() != false;
    }

    public void onClose() {
        this.config.selected = false;
        Consumer<FactoryScreenWindow> onClick = w -> {
            if (w.isVisible()) {
                w.onClickWidget();
            }
        };
        this.parent.children().forEach(l -> {
            if (l instanceof FactoryScreenWindow) {
                FactoryScreenWindow s = (FactoryScreenWindow)l;
                onClick.accept(s);
            }
        });
        T t = this.parent;
        if (t instanceof IWindowWidget) {
            IWindowWidget w2 = (IWindowWidget)t;
            w2.getNestedRenderables().forEach(l -> {
                if (l instanceof FactoryScreenWindow) {
                    FactoryScreenWindow s = (FactoryScreenWindow)l;
                    onClick.accept(s);
                }
            });
        }
    }

    public void onClickWidget() {
        this.alpha = 1.0f;
        this.parent.setFocused((GuiEventListener)this);
    }

    public void onClickOutside(double mouseX, double mouseY) {
        this.setFocused(false);
        this.alpha = 0.88f;
    }

    public boolean keyPressed(int i, int j, int k) {
        if (i == 256 && this.isVisible()) {
            this.onClose();
            return true;
        }
        return false;
    }

    protected void renderBg(GuiGraphics graphics, int i, int j, float f) {
        FactoryGuiMatrixStack.of(graphics.pose()).pushPose();
        FactoryScreenUtil.enableBlend();
        FactoryScreenUtil.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        if (this.backgroundSprite != null) {
            FactoryGuiGraphics.of(graphics).blitSprite(this.backgroundSprite, this.getX(), this.getY(), this.width, this.height);
        } else {
            this.drawable.draw(graphics, this.getX(), this.getY());
        }
        IWindowWidget.super.render(graphics, i, j, f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FactoryScreenUtil.disableBlend();
        FactoryScreenUtil.disableDepthTest();
        FactoryGuiMatrixStack.of(graphics.pose()).popPose();
    }

    @Override
    public List<? extends Renderable> getNestedRenderables() {
        return this.nestedRenderables;
    }

    @Override
    public <R extends Renderable> R addNestedRenderable(R drawable) {
        this.nestedRenderables.add(drawable);
        return drawable;
    }

    protected void renderWidget(GuiGraphics graphics, int i, int j, float f) {
        if (!this.isVisible()) {
            return;
        }
        FactoryGuiMatrixStack.of(graphics.pose()).pushPose();
        FactoryGuiMatrixStack.of(graphics.pose()).translate(0.0, 0.0, this.getBlitOffset());
        this.renderBg(graphics, i, j, f);
        this.renderToolTip(graphics, i, j);
        FactoryGuiMatrixStack.of(graphics.pose()).popPose();
    }

    public float getBlitOffset() {
        return 450.0f;
    }

    public void renderToolTip(GuiGraphics graphics, int i, int j) {
    }

    public boolean isMouseOver(double d, double e) {
        return this.isVisible() && FactoryScreenUtil.isMouseOver(d, e, this.getX(), this.getY(), this.width, this.height);
    }

    public void updateActualMouse(double mouseX, double mouseY) {
        this.actualMouseX = mouseX;
        this.actualMouseY = mouseY;
    }

    public void updateLastMouse(int mouseX, int mouseY) {
        this.lastX = mouseX;
        this.lastY = mouseY;
    }

    @Override
    public boolean mouseClicked(double d, double e, int i) {
        return this.handleClick(d, e, i) || IWindowWidget.super.mouseClicked(d, e, i);
    }

    @Override
    public boolean mouseReleased(double d, double e, int i) {
        return this.handleRelease(d, e, i) || IWindowWidget.super.mouseReleased(d, e, i);
    }

    @Override
    public boolean mouseDragged(double x, double y, int i, double dx, double dy) {
        if (!this.isVisible() || this.parent.isDragging() && !this.dragging) {
            return false;
        }
        if (IWindowWidget.super.mouseDragged(x, y, i, dx, dy)) {
            return true;
        }
        return this.handleDragging(x, y, i, dx, dy);
    }

    public boolean handleClick(double d, double e, int i) {
        if (!this.isVisible()) {
            return false;
        }
        if (i == 0) {
            if (this.isMouseOver(d, e) || this.config.isMouseOver(d, e)) {
                this.onClickWidget();
                if (this.isMouseOver(d, e)) {
                    this.updateActualMouse(d, e);
                }
            } else {
                this.onClickOutside(d, e);
            }
        }
        return false;
    }

    public boolean handleRelease(double d, double e, int i) {
        if (this.dragging) {
            this.dragging = false;
            this.parent.setDragging(false);
            this.updateLastMouse(this.getX(), this.getY());
            return true;
        }
        return false;
    }

    public boolean handleDragging(double x, double y, int i, double dx, double dy) {
        if (i == 0 && (this.isMouseOver(x, y) || this.dragging)) {
            double newX = (double)this.lastX + x - this.actualMouseX;
            double newY = (double)this.lastY + y - this.actualMouseY;
            if (newX + (double)this.width < (double)((AbstractContainerScreen)this.parent).width && newX > 0.0) {
                this.setX((int)newX);
            }
            if (newY + (double)this.height < (double)((AbstractContainerScreen)this.parent).height && newY > 0.0) {
                this.setY((int)newY);
            }
            this.dragging = true;
            this.parent.setDragging(true);
            return true;
        }
        return false;
    }

    @Override
    public Rect2i getBounds() {
        return new Rect2i(this.getX(), this.getY(), this.width, this.height);
    }
}

