/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public enum BlockSide {
    FRONT,
    BACK,
    TOP,
    BOTTOM,
    RIGHT,
    LEFT;

    public static final BlockSide[] FRONT_FACE_SIDES;
    public static final BlockSide[] TOP_FACE_SIDES;

    public Component getComponent() {
        return Component.m_237115_((String)("tooltip.factory_api.gui_" + this.name().toLowerCase(Locale.ENGLISH)));
    }

    public Direction blockStateToFacing(BlockState blockState, BlockSide[] sides) {
        if (blockState.m_61145_((Property)BlockStateProperties.f_61374_).isPresent()) {
            return this.convertToHorizontalFacing((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_), sides);
        }
        if (blockState.m_61145_((Property)BlockStateProperties.f_61372_).isPresent()) {
            return this.convertToFacing((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_), sides);
        }
        return null;
    }

    public Direction blockStateToFacing(BlockState blockState) {
        return this.blockStateToFacing(blockState, BlockSide.values());
    }

    public Direction convertToHorizontalFacing(Direction blockStateDirection, BlockSide[] sides) {
        if (this.equals((Object)sides[0])) {
            return blockStateDirection;
        }
        if (this.equals((Object)sides[1])) {
            return blockStateDirection.m_122424_();
        }
        if (this.equals((Object)sides[2])) {
            return Direction.UP;
        }
        if (this.equals((Object)sides[3])) {
            return Direction.DOWN;
        }
        if (this.equals((Object)sides[4])) {
            return blockStateDirection.m_122428_();
        }
        if (this.equals((Object)sides[5])) {
            return blockStateDirection.m_122427_();
        }
        return blockStateDirection;
    }

    public Direction convertToHorizontalFacing(Direction blockStateDirection) {
        return this.convertToHorizontalFacing(blockStateDirection, BlockSide.values());
    }

    public Direction convertToFacing(Direction d, BlockSide[] sides) {
        if (this == sides[0]) {
            return d;
        }
        if (this == sides[1]) {
            return d.m_122424_();
        }
        if (Direction.Plane.HORIZONTAL.test(d)) {
            if (this == sides[2]) {
                return Direction.UP;
            }
            if (this == sides[3]) {
                return Direction.DOWN;
            }
            if (this == sides[4]) {
                return d.m_122428_();
            }
            if (this == sides[5]) {
                return d.m_122427_();
            }
        } else {
            if (this == sides[2]) {
                return d == Direction.DOWN ? Direction.NORTH : Direction.SOUTH;
            }
            if (this == sides[3]) {
                return d == Direction.DOWN ? Direction.SOUTH : Direction.NORTH;
            }
            if (this == sides[4]) {
                return d == Direction.DOWN ? Direction.EAST : Direction.WEST;
            }
            if (this == sides[5]) {
                return d == Direction.DOWN ? Direction.WEST : Direction.EAST;
            }
        }
        return d;
    }

    public Direction convertToFacing(Direction blockStateDirection) {
        return this.convertToFacing(blockStateDirection, BlockSide.values());
    }

    static {
        FRONT_FACE_SIDES = BlockSide.values();
        TOP_FACE_SIDES = new BlockSide[]{TOP, BOTTOM, FRONT, BACK, RIGHT, LEFT};
    }
}

