/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.ItemContainerPlatform;
import wily.factoryapi.base.FactoryFluidHandler;
import wily.factoryapi.base.IPlatformItemFluidHandler;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.util.FluidInstance;

public class FactoryItemFluidHandler
extends FactoryFluidHandler
implements IPlatformItemFluidHandler {
    private final ItemStack container;

    public FactoryItemFluidHandler(int capacity, ItemStack container) {
        this(capacity, container, f -> true, TransportState.EXTRACT_INSERT);
    }

    public FactoryItemFluidHandler(int capacity, ItemStack stack, Predicate<FluidInstance> validator, TransportState transportState) {
        super(capacity, null, validator, SlotsIdentifier.GENERIC, transportState);
        this.container = stack;
    }

    private CompoundTag getFluidCompound(ItemStack stack) {
        return this.isBlockItem() ? stack.m_41784_().m_128469_("BlockEntityTag").m_128469_("singleTank") : stack.m_41784_().m_128469_(this.getStorageKey());
    }

    public String getStorageKey() {
        return this.isBlockItem() ? "singleTank" : "Fluid";
    }

    public boolean isBlockItem() {
        return ItemContainerPlatform.isBlockItem(this.container);
    }

    @Override
    public void setFluid(FluidInstance fluid) {
        boolean b = this.isBlockItem();
        CompoundTag tag = this.container.m_41784_();
        if (b) {
            tag = tag.m_128469_("BlockEntityTag");
        }
        int capacity = this.getMaxFluid();
        CompoundTag newTag = FluidInstance.toTag(fluid);
        newTag.m_128405_("capacity", capacity);
        tag.m_128365_(this.getStorageKey(), (Tag)newTag);
        if (b) {
            this.container.m_41783_().m_128365_("BlockEntityTag", (Tag)tag);
        }
    }

    @Override
    @NotNull
    public FluidInstance getFluidInstance() {
        return FluidInstance.fromTag(this.getFluidCompound(this.container));
    }

    @Override
    public void deserializeTag(CompoundTag tag) {
        this.getFluidCompound(this.container).m_128365_(this.getStorageKey(), (Tag)tag);
    }

    @Override
    public CompoundTag serializeTag() {
        return this.getFluidCompound(this.container);
    }

    @Override
    public int fill(FluidInstance resource, boolean simulate) {
        if (this.container.m_41613_() != 1 || resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        FluidInstance contained = this.getFluidInstance().copy();
        if (contained.isEmpty()) {
            int fillAmount = Math.min(this.getMaxFluid(), resource.getAmount());
            if (!simulate) {
                FluidInstance filled = resource.copy();
                filled.setAmount(fillAmount);
                this.setFluid(filled);
            }
            return fillAmount;
        }
        if (contained.isFluidEqual(resource)) {
            int fillAmount = Math.min(this.getMaxFluid() - contained.getAmount(), resource.getAmount());
            if (!simulate && fillAmount > 0) {
                contained.grow(fillAmount);
                this.setFluid(contained);
            }
            return fillAmount;
        }
        return 0;
    }

    @Override
    @NotNull
    public FluidInstance drain(int maxDrain, boolean simulate) {
        if (this.container.m_41613_() != 1 || maxDrain <= 0 || !this.getTransport().canExtract()) {
            return FluidInstance.empty();
        }
        FluidInstance contained = this.getFluidInstance().copy();
        if (contained.isEmpty()) {
            return FluidInstance.empty();
        }
        int drainAmount = Math.min(contained.getAmount(), maxDrain);
        FluidInstance drained = contained.copy();
        drained.setAmount(drainAmount);
        if (!simulate) {
            contained.shrink(drainAmount);
            if (contained.isEmpty()) {
                this.setContainerToEmpty();
            } else {
                this.setFluid(contained);
            }
        }
        return drained;
    }

    protected void setContainerToEmpty() {
        this.container.m_41749_(this.getStorageKey());
    }

    @Override
    public void setCapacity(int capacity) {
        boolean b = this.isBlockItem();
        CompoundTag tag = this.container.m_41784_();
        if (b) {
            tag = tag.m_128469_("BlockEntityTag");
        }
        CompoundTag newTag = this.getFluidCompound(this.container);
        newTag.m_128405_("capacity", capacity);
        tag.m_128365_(this.getStorageKey(), (Tag)newTag);
        if (b) {
            this.container.m_41783_().m_128365_("BlockEntityTag", (Tag)tag);
        }
    }

    @Override
    public int getMaxFluid() {
        return this.getFluidCompound(this.container).m_128441_("capacity") ? this.getFluidCompound(this.container).m_128451_("capacity") : super.getMaxFluid();
    }

    @Override
    public ItemStack getContainer() {
        return this.container;
    }
}

