/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.serialization.Codec;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import org.apache.commons.io.FilenameUtils;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.client.FactoryOptions;
import wily.factoryapi.base.client.GuiMetadataSection;

public record MipmapMetadataSection(Map<Integer, Level> levels) {
    public static final MipmapMetadataSection EMPTY = new MipmapMetadataSection(Collections.emptyMap());
    public static final Codec<MipmapMetadataSection> CODEC = Codec.unboundedMap((Codec)Codec.STRING.xmap(Integer::parseInt, Object::toString), Level.CODEC).xmap(MipmapMetadataSection::new, MipmapMetadataSection::levels);
    public static final MetadataSectionType<MipmapMetadataSection> TYPE = GuiMetadataSection.fromCodec("mipmap", CODEC);
    public static final Pattern MANUAL_MIPMAP_PATTERN = Pattern.compile(".+/(\\d).png");

    public static MipmapMetadataSection createFallback(SpriteContents contents, int maxLevel) {
        String baseName = FilenameUtils.getBaseName((String)contents.m_246162_().m_135815_());
        if (!baseName.isEmpty()) {
            MipmapMetadataSection section = new MipmapMetadataSection(new HashMap<Integer, Level>());
            for (int i = 1; i <= maxLevel; ++i) {
                ResourceLocation resourceLocation = contents.m_246162_().m_247449_("%s/%s/%s.png".formatted(FactoryOptions.MANUAL_MIPMAP_PATH.get(), baseName, i));
                Minecraft.m_91087_().m_91098_().m_213713_(resourceLocation).ifPresent(resource -> {
                    Matcher matcher = MANUAL_MIPMAP_PATTERN.matcher(resourceLocation.m_135815_());
                    while (matcher.find()) {
                        if (matcher.group(1) == null) continue;
                        try {
                            Integer level = Integer.parseInt(matcher.group(1));
                            section.levels().put(level, new Level(resourceLocation));
                        }
                        catch (NumberFormatException e) {
                            FactoryAPI.LOGGER.error("Failed to load fallback mipmap level from texture {}: {}", (Object)contents.m_246162_(), (Object)e.getMessage());
                        }
                    }
                });
            }
            return section;
        }
        return EMPTY;
    }

    public record Level(ResourceLocation texture, NativeImage image) {
        public static final Codec<Level> CODEC = ResourceLocation.f_135803_.xmap(Level::new, Level::texture);

        public Level(ResourceLocation texture) {
            this(texture, Level.readSecure(texture));
        }

        public static NativeImage readSecure(ResourceLocation texture) {
            try {
                return NativeImage.m_85058_((InputStream)Minecraft.m_91087_().m_91098_().m_215595_(texture));
            }
            catch (IOException e) {
                FactoryAPI.LOGGER.error("Failed to load mipmap level from texture {}: {}", (Object)texture, (Object)e.getMessage());
                return null;
            }
        }
    }
}

