/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.network;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.base.network.CommonNetwork;

public record CommonConfigSyncPayload(CommonNetwork.Identifier<CommonConfigSyncPayload> identifier, ResourceLocation commonConfigStorage, CompoundTag configTag) implements CommonNetwork.Payload
{
    public static final CommonNetwork.Identifier<CommonConfigSyncPayload> ID_S2C = CommonNetwork.Identifier.create(FactoryAPI.createModLocation("common_config_sync_s2c"), CommonConfigSyncPayload::createS2C);
    public static final CommonNetwork.Identifier<CommonConfigSyncPayload> ID_C2S = CommonNetwork.Identifier.create(FactoryAPI.createModLocation("common_config_sync_c2s"), CommonConfigSyncPayload::createC2S);

    public CommonConfigSyncPayload(CommonNetwork.Identifier<CommonConfigSyncPayload> identifier, CommonNetwork.PlayBuf playBuf) {
        this(identifier, ((FriendlyByteBuf)playBuf.get()).m_130281_(), ((FriendlyByteBuf)playBuf.get()).m_130260_());
    }

    public static CommonConfigSyncPayload of(CommonNetwork.Identifier<CommonConfigSyncPayload> identifier, FactoryConfig.StorageHandler handler) {
        return new CommonConfigSyncPayload(identifier, FactoryConfig.COMMON_STORAGES.getKey(handler), (CompoundTag)handler.encodeConfigs(NbtOps.f_128958_));
    }

    public static CommonConfigSyncPayload of(CommonNetwork.Identifier<CommonConfigSyncPayload> identifier, FactoryConfig.StorageHandler handler, FactoryConfig<?> config) {
        return new CommonConfigSyncPayload(identifier, FactoryConfig.COMMON_STORAGES.getKey(handler), (CompoundTag)FactoryConfig.encodeConfigs(Map.of(config.getKey(), config), NbtOps.f_128958_));
    }

    public static CommonConfigSyncPayload createS2C(CommonNetwork.PlayBuf playBuf) {
        return new CommonConfigSyncPayload(ID_S2C, playBuf);
    }

    public static CommonConfigSyncPayload createC2S(CommonNetwork.PlayBuf playBuf) {
        return new CommonConfigSyncPayload(ID_C2S, playBuf);
    }

    @Override
    public void apply(CommonNetwork.Payload.Context context) {
        ServerPlayer sp;
        Player player;
        FactoryConfig.COMMON_STORAGES.get(this.commonConfigStorage).decodeConfigs(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)this.configTag));
        if (!context.isClient() && (player = context.player()) instanceof ServerPlayer && (sp = (ServerPlayer)player).m_20310_(2)) {
            FactoryConfig.StorageHandler handler = FactoryConfig.COMMON_STORAGES.get(this.commonConfigStorage);
            CommonNetwork.sendToPlayers(FactoryAPIPlatform.getEntityServer((Entity)sp).m_6846_().m_11314_(), new CommonConfigSyncPayload(ID_S2C, this.commonConfigStorage, this.configTag));
            handler.save();
        }
    }

    @Override
    public void encode(CommonNetwork.PlayBuf playBuf) {
        ((FriendlyByteBuf)playBuf.get()).m_130085_(this.commonConfigStorage);
        ((FriendlyByteBuf)playBuf.get()).m_130079_(this.configTag);
    }
}

