/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.mixin.base;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.gui.RealmsDataFetcher;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ProfileKeyPairManager;
import net.minecraft.client.multiplayer.chat.report.ReportEnvironment;
import net.minecraft.client.multiplayer.chat.report.ReportingContext;
import net.minecraft.client.resources.SplashManager;
import net.minecraft.client.telemetry.ClientTelemetryManager;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.client.MinecraftAccessor;
import wily.factoryapi.base.client.UIAccessor;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin
implements MinecraftAccessor {
    @Shadow
    @Nullable
    public ClientLevel f_91073_;
    @Shadow
    @Final
    public Gui f_91065_;
    @Mutable
    @Shadow
    @Final
    private User f_90998_;
    @Mutable
    @Shadow
    @Final
    private ProfileKeyPairManager f_231337_;
    @Mutable
    @Shadow
    @Final
    private UserApiService f_193584_;
    @Shadow
    @Final
    private YggdrasilAuthenticationService f_231338_;
    @Mutable
    @Shadow
    @Final
    private ClientTelemetryManager f_260676_;
    @Shadow
    @Final
    private static Logger f_90982_;
    @Shadow
    private ReportingContext f_238638_;
    @Mutable
    @Shadow
    @Final
    private RealmsDataFetcher f_238717_;
    @Shadow
    @Final
    private SplashManager f_91046_;
    @Unique
    boolean gameLoaded = false;

    @Inject(method={"resizeDisplay"}, at={@At(value="RETURN")})
    public void resizeDisplay(CallbackInfo ci) {
        if (this.f_91073_ != null) {
            UIAccessor.of(this.f_91065_).reloadUI();
            ((Consumer)FactoryAPIClient.RESIZE_DISPLAY.invoker).accept(Minecraft.m_91087_());
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="RETURN")})
    public void setScreen(Screen screen, CallbackInfo ci) {
        if (this.f_91073_ != null) {
            UIAccessor.of(this.f_91065_).reloadUI();
        }
    }

    @Inject(method={"stop"}, at={@At(value="RETURN")})
    public void stop(CallbackInfo ci) {
        ((Consumer)FactoryAPIClient.STOPPING.invoker).accept(Minecraft.m_91087_());
    }

    @Override
    @Accessor
    public abstract float getPausePartialTick();

    @Inject(method={"onGameLoadFinished"}, at={@At(value="RETURN")})
    public void onGameLoadFinished(CallbackInfo ci) {
        this.gameLoaded = true;
    }

    @Override
    public boolean hasGameLoaded() {
        return this.gameLoaded;
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;wrapScreenError(Ljava/lang/Runnable;Ljava/lang/String;Ljava/lang/String;)V")})
    public void beforeScreenTick(CallbackInfo ci) {
        if (Minecraft.m_91087_().f_91080_ == null) {
            return;
        }
        UIAccessor accessor = UIAccessor.of(Minecraft.m_91087_().f_91080_);
        Screen.m_96579_(accessor::beforeTick, (String)"Ticking screen before tick", (String)Minecraft.m_91087_().f_91080_.getClass().getCanonicalName());
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;wrapScreenError(Ljava/lang/Runnable;Ljava/lang/String;Ljava/lang/String;)V", shift=At.Shift.AFTER)})
    public void afterScreenTick(CallbackInfo ci) {
        if (Minecraft.m_91087_().f_91080_ == null) {
            return;
        }
        UIAccessor accessor = UIAccessor.of(Minecraft.m_91087_().f_91080_);
        Screen.m_96579_(accessor::afterTick, (String)"Ticking screen after tick", (String)Minecraft.m_91087_().f_91080_.getClass().getCanonicalName());
    }

    @Override
    public boolean setUser(User user) {
        if (user == null) {
            f_90982_.warn("Something went wrong, the User cannot be set to null");
            return false;
        }
        this.f_90998_ = this.f_91046_.f_118863_ = user;
        MinecraftSessionService session = Minecraft.m_91087_().m_91108_();
        boolean offlineDeveloperMode = user.m_168638_() != User.Type.MSA;
        try {
            this.f_193584_ = this.f_231338_.createUserApiService(user.m_92547_());
        }
        catch (AuthenticationException var4) {
            AuthenticationException authenticationException = var4;
            f_90982_.error("Failed to verify authentication", (Throwable)authenticationException);
            this.f_193584_ = UserApiService.OFFLINE;
        }
        this.f_231337_ = ProfileKeyPairManager.m_252915_((UserApiService)this.f_193584_, (User)user, (Path)Minecraft.m_91087_().f_91069_.toPath());
        this.f_260676_ = new ClientTelemetryManager(Minecraft.m_91087_(), this.f_193584_, user);
        this.f_238638_ = ReportingContext.m_239685_((ReportEnvironment)ReportEnvironment.m_239898_(), (UserApiService)this.f_193584_);
        this.f_238717_ = new RealmsDataFetcher(RealmsClient.m_239151_((Minecraft)Minecraft.m_91087_()));
        return true;
    }
}

