/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.mixin.base;

import java.util.Map;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.FactoryGuiGraphics;

@Mixin(value={TextureAtlas.class})
public class TextureAtlasMixin
implements FactoryGuiGraphics.AtlasAccessor {
    @Shadow
    private Map<ResourceLocation, TextureAtlasSprite> f_118264_;
    @Shadow
    @Final
    private ResourceLocation f_118265_;
    @Unique
    private TextureAtlasSprite missingSprite;

    @Inject(method={"upload"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/texture/TextureAtlas;texturesByName:Ljava/util/Map;", opcode=181, shift=At.Shift.AFTER)})
    private void init(SpriteLoader.Preparations preparations, CallbackInfo ci) {
        this.missingSprite = this.f_118264_.get(MissingTextureAtlasSprite.m_118071_());
        if (this.missingSprite == null) {
            throw new IllegalStateException("Atlas '" + String.valueOf(this.f_118265_) + "' (" + this.f_118264_.size() + " sprites) has no missing texture sprite");
        }
    }

    @Inject(method={"getSprite"}, at={@At(value="HEAD")}, cancellable=true)
    public void getSprite(ResourceLocation resourceLocation, CallbackInfoReturnable<TextureAtlasSprite> cir) {
        TextureAtlasSprite textureAtlasSprite = this.f_118264_.getOrDefault(resourceLocation, this.missingSprite);
        if (textureAtlasSprite == null) {
            throw new IllegalStateException("Tried to lookup sprite, but atlas is not initialized");
        }
        cir.setReturnValue((Object)textureAtlasSprite);
    }

    @Override
    public Map<ResourceLocation, TextureAtlasSprite> getTexturesByName() {
        return this.f_118264_;
    }
}

