/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.util.ListMap;

public class DynamicUtil {
    public static final ListMap<ResourceLocation, ArbitrarySupplier<ItemStack>> COMMON_ITEMS = new ListMap();
    public static final LoadingCache<Pair<Dynamic<?>, Boolean>, ItemStack> DYNAMIC_ITEMS_CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(pair -> ((Dynamic)pair.getFirst()).get("item").asString().result().or(() -> ((Dynamic)pair.getFirst()).asString().result()).map(s -> ((Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.m_135820_((String)s))).m_7968_()).map(i -> {
        ((Dynamic)pair.getFirst()).get("count").result().flatMap(d1 -> Codec.INT.parse(d1).result()).ifPresent(arg_0 -> ((ItemStack)i).m_41764_(arg_0));
        if (((Boolean)pair.getSecond()).booleanValue()) {
            ((Dynamic)pair.getFirst()).get("nbt").result().flatMap(d1 -> CompoundTag.f_128325_.parse(d1).result()).ifPresent(arg_0 -> ((ItemStack)i).m_41751_(arg_0));
        }
        return i;
    }).orElse(ItemStack.f_41583_)));
    public static final LoadingCache<DynamicOps<?>, RegistryOps<?>> REGISTRY_OPS_CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(o -> RegistryOps.m_255058_((DynamicOps)o, (HolderLookup.Provider)FactoryAPIPlatform.getRegistryAccess())));
    public static final Codec<Vec3> VEC3_OPTIONAL_CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.DOUBLE.fieldOf("x").orElse((Object)0.0).forGetter(Vec3::m_7096_), (App)Codec.DOUBLE.fieldOf("y").orElse((Object)0.0).forGetter(Vec3::m_7098_), (App)Codec.DOUBLE.fieldOf("z").orElse((Object)0.0).forGetter(Vec3::m_7094_)).apply((Applicative)i, Vec3::new));
    public static final Codec<Vec3> VEC3_OBJECT_CODEC = Codec.either(VEC3_OPTIONAL_CODEC, (Codec)Vec3.f_231074_).xmap(e -> (Vec3)e.map(v -> v, v -> v), Either::right);
    public static final Codec<Vec2> VEC2_OPTIONAL_CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.fieldOf("x").orElse((Object)Float.valueOf(0.0f)).forGetter(vec2 -> Float.valueOf(vec2.f_82470_)), (App)Codec.FLOAT.fieldOf("y").orElse((Object)Float.valueOf(0.0f)).forGetter(vec2 -> Float.valueOf(vec2.f_82471_))).apply((Applicative)i, Vec2::new));
    public static final Codec<Vec2> VEC2_CODEC = Codec.either(VEC2_OPTIONAL_CODEC, (Codec)Codec.FLOAT.listOf().comapFlatMap(list -> Util.m_143795_((List)list, (int)2).map(listx -> new Vec2(((Float)listx.get(0)).floatValue(), ((Float)listx.get(1)).floatValue())), vec3 -> List.of(Float.valueOf(vec3.f_82470_), Float.valueOf(vec3.f_82471_)))).xmap(e -> (Vec2)e.map(v -> v, v -> v), Either::right);
    public static final Codec<ItemStack> COMPLETE_ITEM_CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.f_257033_.m_206110_().fieldOf("item").forGetter(ItemStack::m_220173_), (App)Codec.INT.fieldOf("count").orElse((Object)1).forGetter(ItemStack::m_41613_), (App)CompoundTag.f_128325_.optionalFieldOf("nbt").forGetter(itemStack -> Optional.ofNullable(itemStack.m_41783_()))).apply((Applicative)i, (item, count, nbt) -> {
        ItemStack stack = new ItemStack(item, count.intValue());
        stack.m_41751_((CompoundTag)nbt.orElse(null));
        return stack;
    }));
    public static final Codec<ItemStack> ITEM_CODEC = Codec.either((Codec)BuiltInRegistries.f_257033_.m_206110_().xmap(ItemStack::new, ItemStack::m_220173_), COMPLETE_ITEM_CODEC).xmap(e -> e.right().orElseGet(e.left()::get), Either::right);
    public static Codec<ArbitrarySupplier<ItemStack>> ITEM_WITHOUT_DATA_SUPPLIER_CODEC = Codec.of((Encoder)ITEM_CODEC.xmap(ArbitrarySupplier::of, Supplier::get), DynamicUtil::getItemWithoutDataFromDynamic);
    public static Codec<ArbitrarySupplier<ItemStack>> ITEM_SUPPLIER_CODEC = Codec.of((Encoder)ITEM_CODEC.xmap(ArbitrarySupplier::of, Supplier::get), DynamicUtil::getItemFromDynamic);

    public static <T> DataResult<Pair<ArbitrarySupplier<ItemStack>, T>> getItemWithoutDataFromDynamic(DynamicOps<T> ops, T input) {
        return DynamicUtil.getItemFromDynamic(ops, input, false);
    }

    public static <T> DataResult<Pair<ArbitrarySupplier<ItemStack>, T>> getItemFromDynamic(DynamicOps<T> ops, T input) {
        return DynamicUtil.getItemFromDynamic(ops, input, true);
    }

    public static <T> DataResult<Pair<ArbitrarySupplier<ItemStack>, T>> getItemFromDynamic(DynamicOps<T> ops, T input, boolean allowData) {
        return DataResult.success((Object)Pair.of(DynamicUtil.getItemFromDynamic(new Dynamic(ops, input), allowData), input));
    }

    public static ArbitrarySupplier<ItemStack> getItemFromDynamic(Dynamic<?> element, boolean allowData) {
        return element.get("common_item").asString().map(s -> COMMON_ITEMS.get(ResourceLocation.m_135820_((String)s))).result().orElseGet(() -> {
            Pair pair = Pair.of((Object)element, (Object)allowData);
            DYNAMIC_ITEMS_CACHE.refresh((Object)pair);
            return () -> (ItemStack)DYNAMIC_ITEMS_CACHE.getUnchecked((Object)pair);
        });
    }

    public static <T> Dynamic<T> convertToRegistryIfPossible(Dynamic<T> dynamic) {
        return !(dynamic.getOps() instanceof RegistryOps) && (!FactoryAPI.isClient() || FactoryAPIClient.hasLevel()) ? dynamic.convert(DynamicUtil.getActualRegistryOps(dynamic.getOps())) : dynamic;
    }

    public static <T> DynamicOps<T> getActualRegistryOps(DynamicOps<T> ops) {
        return FactoryAPI.isClient() && !FactoryAPIClient.hasLevel() ? ops : (DynamicOps)REGISTRY_OPS_CACHE.getUnchecked(ops);
    }

    public static Codec<Component> getComponentCodec() {
        return ExtraCodecs.f_252442_;
    }
}

