/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Duration;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class ElementId {
    public static final LoadingCache<String[], ElementId> CACHE = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(4L)).build(CacheLoader.from(ElementId::create));
    protected static final LoadingCache<String[], ElementId> PROCESSED_CACHE = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(5L)).build(CacheLoader.from(ElementId::new));
    protected final String[] parts;
    protected String toString;
    protected final int hash;

    protected ElementId(String[] parts) {
        this.parts = parts;
        this.hash = Arrays.hashCode(parts);
    }

    protected static ElementId create(String[] parts) {
        return new ElementId(ElementId.processParts(parts));
    }

    protected static String[] processParts(String[] parts) {
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (!part.contains(".")) continue;
            Object[] newParts = part.split("\\.");
            parts = (String[])ArrayUtils.insert((int)i, (Object[])((String[])ArrayUtils.remove((Object[])parts, (int)i)), (Object[])newParts);
            i += newParts.length - 1;
        }
        return parts;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = String.join((CharSequence)".", this.parts);
        }
        return this.toString;
    }

    public static ElementId of(String ... parts) {
        return (ElementId)CACHE.getUnchecked((Object)parts);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof ElementId)) return false;
        ElementId id = (ElementId)obj;
        if (!Arrays.equals(this.parts, id.parts)) return false;
        return true;
    }

    public int hashCode() {
        return this.hash;
    }

    public static ElementId of(String path, @Nullable ElementId thisReplacement) {
        Object[] parsed = ElementId.of((String[])new String[]{path}).parts;
        if (thisReplacement != null && parsed[0].equals("this")) {
            parsed = (String[])ArrayUtils.remove((Object[])parsed, (int)0);
            parsed = (String[])ArrayUtils.insert((int)0, (Object[])parsed, (Object[])thisReplacement.parts);
        }
        return (ElementId)PROCESSED_CACHE.getUnchecked((Object)parsed);
    }

    public String get(int index) {
        return this.parts[index];
    }

    public String last() {
        return this.get(this.parts.length - 1);
    }

    public ElementId parent() {
        return (ElementId)PROCESSED_CACHE.getUnchecked((Object)((String[])ArrayUtils.remove((Object[])this.parts, (int)(this.parts.length - 1))));
    }

    public ElementId resolve(String child) {
        return (ElementId)PROCESSED_CACHE.getUnchecked((Object)((String[])ArrayUtils.addAll((Object[])this.parts, (Object[])ElementId.of((String[])new String[]{child}).parts)));
    }
}

