/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.FactoryGuiMatrixStack;
import wily.factoryapi.base.client.IFactoryItemClientExtension;
import wily.factoryapi.base.client.UIAccessor;

public class FactoryScreenUtil {
    private static final Minecraft mc = Minecraft.m_91087_();

    public static void drawString(FactoryGuiMatrixStack stack, String text, int x, int y, int color, boolean shadow) {
        Font font = FactoryScreenUtil.mc.f_91062_;
        MultiBufferSource.BufferSource source = mc.m_91269_().m_110104_();
        font.m_272078_(text, (float)x, (float)y, color, shadow, ((PoseStack)stack.getNative()).m_85850_().m_252922_(), (MultiBufferSource)source, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.m_92718_());
        FactoryScreenUtil.disableDepthTest();
        source.m_109911_();
        FactoryScreenUtil.enableDepthTest();
    }

    public static void disableDepthTest() {
        GlStateManager._disableDepthTest();
    }

    public static void enableDepthTest() {
        GlStateManager._enableDepthTest();
    }

    public static void disableBlend() {
        GlStateManager._disableBlend();
    }

    public static void enableBlend() {
        GlStateManager._enableBlend();
    }

    public static void setShaderColor(float r, float g, float b, float a) {
    }

    public static void prepTextScale(FactoryGuiMatrixStack poseStack, Consumer<FactoryGuiMatrixStack> runnable, float x, float y, float scale) {
        float yAdd = 4.0f - scale * 8.0f / 2.0f;
        poseStack.pushPose();
        poseStack.translate(x, y + yAdd, 0.0);
        poseStack.scale(scale, scale, scale);
        runnable.accept(poseStack);
        poseStack.popPose();
        FactoryScreenUtil.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static ScreenRectangle rect2iToRectangle(Rect2i rect) {
        return new ScreenRectangle(new ScreenPosition(rect.m_110085_(), rect.m_110086_()), rect.m_110090_(), rect.m_110091_());
    }

    public static void renderGuiBlock(GuiGraphics graphics, @Nullable BlockEntity be, BlockState state, int i, int j, float scaleX, float scaleY, float rotateX, float rotateY) {
        BlockEntityRenderer blockEntityRenderer;
        Item item = state.m_60734_().m_5456_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)i + 8.0f, (float)j + 8.0f, 250.0f);
        graphics.m_280168_().m_85841_(1.0f, -1.0f, 1.0f);
        graphics.m_280168_().m_85841_(16.0f, 16.0f, 16.0f);
        graphics.m_280168_().m_85841_(scaleX, scaleY, 0.5f);
        graphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(rotateX));
        graphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(rotateY));
        graphics.m_280168_().m_252880_(-0.5f, -0.5f, -0.5f);
        Lighting.m_84930_();
        if (be == null || (blockEntityRenderer = mc.m_167982_().m_112265_(be)) == null) {
            IFactoryItemClientExtension e = IFactoryItemClientExtension.map.get(item);
            if (e != null && e.getCustomRenderer() != null) {
                e.getCustomRenderer().renderByItemBlockState(state, item.m_7968_(), ItemDisplayContext.NONE, graphics.m_280168_(), (MultiBufferSource)FactoryGuiGraphics.of(graphics).getBufferSource(), 0xF000F0, OverlayTexture.f_118083_);
            } else {
                mc.m_91289_().m_110912_(state, graphics.m_280168_(), (MultiBufferSource)FactoryGuiGraphics.of(graphics).getBufferSource(), 0xF000F0, OverlayTexture.f_118083_);
            }
        } else {
            blockEntityRenderer.m_6922_(be, FactoryAPIClient.getGamePartialTick(true), graphics.m_280168_(), (MultiBufferSource)FactoryGuiGraphics.of(graphics).getBufferSource(), 0xF000F0, OverlayTexture.f_118083_);
        }
        graphics.m_280262_();
        graphics.m_280168_().m_85849_();
    }

    public static void playButtonDownSound(float grave) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)grave));
    }

    public static boolean isMouseOver(double mouseX, double mouseY, int posX, int posY, int sizeX, int sizeY) {
        return mouseX >= (double)posX && mouseX < (double)(posX + sizeX) && mouseY >= (double)posY && mouseY < (double)(posY + sizeY);
    }

    public static void applyOffset(GuiGraphics graphics, float x, float y, float z) {
        if (x != 0.0f || y != 0.0f | z != 0.0f) {
            FactoryGuiMatrixStack.of(graphics.m_280168_()).translate(x, y, z);
        }
    }

    public static void applyScale(GuiGraphics graphics, float x, float y, float z) {
        if (x != 1.0f || y != 1.0f || z != 1.0f) {
            FactoryGuiMatrixStack.of(graphics.m_280168_()).scale(x, y, z);
        }
    }

    public static void applyColor(GuiGraphics graphics, int color) {
        if (color != -1) {
            FactoryGuiGraphics.of(graphics).setColor(color, true);
        }
    }

    public static UIAccessor getScreenAccessor() {
        return UIAccessor.of(FactoryScreenUtil.mc.f_91080_);
    }

    public static UIAccessor getGuiAccessor() {
        return UIAccessor.of(FactoryScreenUtil.mc.f_91065_);
    }
}

