/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi;

import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.mixin.transfer.BucketItemAccessor;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1755;
import net.minecraft.class_1799;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import wily.factoryapi.util.FluidInstance;

public interface ItemContainerPlatform {
    public static boolean isBlockItem(class_1799 s) {
        return s.method_7909() instanceof class_1747;
    }

    public static class_3611 getBucketFluid(class_1755 item) {
        return ((BucketItemAccessor)item).fabric_getFluid();
    }

    public static boolean isFluidContainer(class_1799 stack) {
        return FluidStorage.ITEM.find(stack, (Object)ItemContainerPlatform.modifiableStackContext(stack)) != null;
    }

    public static boolean isEnergyContainer(class_1799 stack) {
        return EnergyStorage.ITEM.find(stack, (Object)ItemContainerPlatform.modifiableStackContext(stack)) != null;
    }

    public static FluidInstance getFluid(class_1799 stack) {
        return ItemContainerPlatform.getFluid(stack, ItemContainerPlatform.modifiableStackContext(stack));
    }

    public static FluidInstance getFluid(class_1657 player, class_1268 hand) {
        return ItemContainerPlatform.getFluid(player.method_5998(hand), ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand));
    }

    public static int fillItem(FluidInstance fluidInstance, class_1657 player, class_1268 hand) {
        return ItemContainerPlatform.fillItem(fluidInstance, player.method_5998(hand), ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand), player).fluidInstance().getAmount();
    }

    public static ItemFluidContext fillItem(class_1799 stack, FluidInstance fluidInstance) {
        return ItemContainerPlatform.fillItem(fluidInstance, stack, ItemContainerPlatform.modifiableStackContext(stack), null);
    }

    public static FluidInstance drainItem(int maxDrain, class_1657 player, class_1268 hand) {
        return ItemContainerPlatform.drainItem(maxDrain, player.method_5998(hand), ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand), player).fluidInstance();
    }

    public static ItemFluidContext drainItem(int maxDrain, class_1799 stack) {
        return ItemContainerPlatform.drainItem(maxDrain, stack, ItemContainerPlatform.modifiableStackContext(stack), null);
    }

    public static int insertEnergy(int energy, class_1657 player, class_1268 hand) {
        return ItemContainerPlatform.insertEnergy(energy, ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand), player).contextEnergy();
    }

    public static ItemEnergyContext insertEnergy(int energy, class_1799 stack) {
        return ItemContainerPlatform.insertEnergy(energy, ItemContainerPlatform.modifiableStackContext(stack), null);
    }

    public static int extractEnergy(int energy, class_1657 player, class_1268 hand) {
        return ItemContainerPlatform.extractEnergy(energy, ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand), player).contextEnergy();
    }

    public static ItemEnergyContext extractEnergy(int energy, class_1799 stack) {
        return ItemContainerPlatform.extractEnergy(energy, ItemContainerPlatform.modifiableStackContext(stack), null);
    }

    public static int getEnergy(class_1799 stack) {
        EnergyStorage handStorage = (EnergyStorage)ItemContainerPlatform.modifiableStackContext(stack).find(EnergyStorage.ITEM);
        if (handStorage != null) {
            return (int)handStorage.getAmount();
        }
        return 0;
    }

    public static ContainerItemContext modifiableStackContext(final class_1799 stack) {
        return ContainerItemContext.ofSingleSlot((SingleSlotStorage)new SingleItemStorage(){
            class_1799 itemStack;
            {
                this.itemStack = stack;
            }

            public ItemVariant getResource() {
                return ItemVariant.of((class_1799)this.itemStack);
            }

            public long getAmount() {
                return this.itemStack.method_7947();
            }

            public boolean isResourceBlank() {
                return this.itemStack.method_7960();
            }

            protected long getCapacity(ItemVariant variant) {
                return this.itemStack.method_7914();
            }

            public long insert(ItemVariant insertedVariant, long maxAmount, TransactionContext transaction) {
                StoragePreconditions.notBlankNotNegative((TransferVariant)insertedVariant, (long)maxAmount);
                if (insertedVariant.isOf((Object)this.itemStack.method_7909())) {
                    int oldCount = this.itemStack.method_7947();
                    this.itemStack.method_7933(Math.min(stack.method_7914(), (int)maxAmount));
                    return this.itemStack.method_7947() - oldCount;
                }
                if (this.itemStack.method_7960()) {
                    this.itemStack = insertedVariant.toStack(Math.min(this.itemStack.method_7914(), (int)maxAmount));
                    return this.itemStack.method_7947();
                }
                return 0L;
            }

            public long extract(ItemVariant extractedVariant, long maxAmount, TransactionContext transaction) {
                StoragePreconditions.notBlankNotNegative((TransferVariant)extractedVariant, (long)maxAmount);
                if (extractedVariant.isOf((Object)this.itemStack.method_7909())) {
                    int oldCount = this.itemStack.method_7947();
                    this.itemStack.method_7934(Math.max(this.itemStack.method_7947(), (int)maxAmount));
                    return oldCount - this.itemStack.method_7947();
                }
                return 0L;
            }
        });
    }

    public static FluidInstance getFluid(class_1799 stack, ContainerItemContext context) {
        Iterator iterator;
        Storage handStorage = (Storage)FluidStorage.ITEM.find(stack, (Object)context);
        if (handStorage != null && (iterator = handStorage.iterator()).hasNext()) {
            StorageView view = (StorageView)iterator.next();
            return FluidInstance.create(((FluidVariant)view.getResource()).getFluid(), view.getAmount());
        }
        return FluidInstance.empty();
    }

    public static ItemFluidContext fillItem(FluidInstance fluidInstance, class_1799 stack, ContainerItemContext context, @Nullable class_1657 player) {
        long amount = fluidInstance.getPlatformAmount();
        StoragePreconditions.notBlankNotNegative((TransferVariant)FluidVariant.of((class_3611)fluidInstance.getFluid()), (long)amount);
        Storage handStorage = (Storage)FluidStorage.ITEM.find(stack, (Object)context);
        if (handStorage != null) {
            try (Transaction transaction = Transaction.openOuter();){
                try (Transaction nested = transaction.openNested();){
                    fluidInstance.setAmount(handStorage.insert((Object)FluidVariant.of((class_3611)fluidInstance.getFluid()), amount, (TransactionContext)nested));
                    if (player != null) {
                        player.method_37908().method_43128(null, player.method_23317(), player.method_23318() + 0.5, player.method_23321(), FluidVariantAttributes.getFillSound((FluidVariant)FluidVariant.of((class_3611)fluidInstance.getFluid())), class_3419.field_15248, 1.0f, 1.0f);
                        if (!player.method_68878()) {
                            nested.commit();
                        }
                    } else {
                        nested.commit();
                    }
                }
                transaction.commit();
                ItemFluidContext itemFluidContext = new ItemFluidContext(fluidInstance, context.getItemVariant().toStack((int)context.getAmount()));
                return itemFluidContext;
            }
        }
        return new ItemFluidContext(context.getItemVariant().toStack((int)context.getAmount()));
    }

    public static ItemFluidContext drainItem(int maxDrain, class_1799 stack, ContainerItemContext context, @Nullable class_1657 player) {
        Storage handStorage = (Storage)FluidStorage.ITEM.find(stack, (Object)context);
        if (handStorage != null) {
            for (StorageView view : handStorage) {
                if (view.isResourceBlank()) continue;
                FluidVariant storedResource = (FluidVariant)view.getResource();
                try (Transaction transaction = Transaction.openOuter();){
                    long amount;
                    try (Transaction nested = transaction.openNested();){
                        amount = view.extract((Object)storedResource, FluidInstance.getPlatformFluidAmount(maxDrain), (TransactionContext)nested);
                        if (player != null) {
                            if (amount > 0L) {
                                player.method_37908().method_43128(null, player.method_23317(), player.method_23318() + 0.5, player.method_23321(), FluidVariantAttributes.getEmptySound((FluidVariant)storedResource), class_3419.field_15245, 1.0f, 1.0f);
                            }
                            if (!player.method_68878()) {
                                nested.commit();
                            }
                        } else {
                            nested.commit();
                        }
                    }
                    transaction.commit();
                    ItemFluidContext itemFluidContext = new ItemFluidContext(FluidInstance.create(storedResource.getFluid(), amount), context.getItemVariant().toStack((int)context.getAmount()));
                    return itemFluidContext;
                }
            }
        }
        return new ItemFluidContext(context.getItemVariant().toStack((int)context.getAmount()));
    }

    public static ItemEnergyContext insertEnergy(int energy, ContainerItemContext context, class_1657 player) {
        StoragePreconditions.notNegative((long)energy);
        EnergyStorage handStorage = (EnergyStorage)context.find(EnergyStorage.ITEM);
        if (handStorage != null) {
            try (Transaction transaction = Transaction.openOuter();){
                try (Transaction nested = transaction.openNested();){
                    energy = (int)handStorage.insert((long)energy, (TransactionContext)nested);
                    if (player == null || !player.method_68878()) {
                        nested.commit();
                    }
                }
                transaction.commit();
                ItemEnergyContext itemEnergyContext = new ItemEnergyContext(energy, context.getItemVariant().toStack((int)context.getAmount()));
                return itemEnergyContext;
            }
        }
        return new ItemEnergyContext(0, context.getItemVariant().toStack((int)context.getAmount()));
    }

    public static ItemEnergyContext extractEnergy(int energy, ContainerItemContext context, class_1657 player) {
        StoragePreconditions.notNegative((long)energy);
        EnergyStorage handStorage = (EnergyStorage)context.find(EnergyStorage.ITEM);
        if (handStorage != null) {
            try (Transaction transaction = Transaction.openOuter();){
                int amount;
                try (Transaction nested = transaction.openNested();){
                    amount = (int)handStorage.extract((long)energy, (TransactionContext)nested);
                    if (player == null || !player.method_68878()) {
                        nested.commit();
                    }
                }
                transaction.commit();
                ItemEnergyContext itemEnergyContext = new ItemEnergyContext(amount, context.getItemVariant().toStack((int)context.getAmount()));
                return itemEnergyContext;
            }
        }
        return new ItemEnergyContext(0, context.getItemVariant().toStack((int)context.getAmount()));
    }

    public record ItemFluidContext(FluidInstance fluidInstance, class_1799 container) {
        public ItemFluidContext(class_1799 container) {
            this(FluidInstance.empty(), container);
        }
    }

    public record ItemEnergyContext(int contextEnergy, class_1799 container) {
        public ItemEnergyContext(class_1799 container) {
            this(0, container);
        }
    }
}

