/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.fabric;

import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2487;
import team.reborn.energy.api.EnergyStorage;
import wily.factoryapi.base.IPlatformEnergyStorage;
import wily.factoryapi.base.IPlatformHandlerApi;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.util.CompoundTagUtil;

public interface FabricEnergyStoragePlatform
extends IPlatformEnergyStorage,
IPlatformHandlerApi<EnergyStorage> {
    public static final String KEY = "energy";

    @Override
    default public int receiveEnergy(int energy, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            int i;
            try (Transaction nested = transaction.openNested();){
                i = (int)((EnergyStorage)this.getHandler()).insert((long)energy, (TransactionContext)nested);
                if (!simulate) {
                    nested.commit();
                }
            }
            transaction.commit();
            int n = i;
            return n;
        }
    }

    @Override
    default public int consumeEnergy(int energy, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            int i;
            try (Transaction nested = transaction.openNested();){
                i = (int)((EnergyStorage)this.getHandler()).extract((long)energy, (TransactionContext)nested);
                if (!simulate) {
                    nested.commit();
                }
            }
            transaction.commit();
            int n = i;
            return n;
        }
    }

    @Override
    default public int getEnergyStored() {
        return (int)((EnergyStorage)this.getHandler()).getAmount();
    }

    @Override
    default public int getMaxEnergyStored() {
        return (int)((EnergyStorage)this.getHandler()).getCapacity();
    }

    @Override
    default public void setEnergyStored(int energy) {
        this.consumeEnergy(this.getEnergyStored(), false);
        this.receiveEnergy(energy, false);
    }

    @Override
    default public int getMaxConsume() {
        return (int)((EnergyStorage)this.getHandler()).getCapacity();
    }

    @Override
    default public TransportState getTransport() {
        return TransportState.ofBoolean(((EnergyStorage)this.getHandler()).supportsExtraction(), ((EnergyStorage)this.getHandler()).supportsInsertion());
    }

    @Override
    default public class_2487 serializeTag() {
        class_2487 tag = new class_2487();
        tag.method_10569(KEY, this.getEnergyStored());
        return tag;
    }

    @Override
    default public void deserializeTag(class_2487 tag) {
        this.setEnergyStored(CompoundTagUtil.getInt(tag, KEY).orElse(0));
    }
}

