/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.network;

import com.google.gson.JsonElement;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2179;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7157;
import net.minecraft.class_9129;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.client.UIDefinitionManager;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.base.network.CommonNetwork;

public class FactoryAPICommand {
    public static void register(CommandDispatcher<class_2168> commandDispatcher, class_7157 commandBuildContext) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)"factoryapi").requires(commandSourceStack -> commandSourceStack.method_9259(2));
        command.then(class_2170.method_9247((String)"display").then(class_2170.method_9247((String)"ui_definition").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"ui_definition", (ArgumentType)class_2179.method_9284()).executes(context -> {
            CommonNetwork.sendToPlayers(class_2186.method_9312((CommandContext)context, (String)"targets"), new UIDefinitionPayload(Optional.empty(), class_2179.method_9285((CommandContext)context, (String)"ui_definition")));
            return 0;
        })).then(class_2170.method_9244((String)"default_screen", (ArgumentType)class_2232.method_9441()).executes(context -> {
            CommonNetwork.sendToPlayers(class_2186.method_9312((CommandContext)context, (String)"targets"), new UIDefinitionPayload(Optional.of(class_2232.method_9443((CommandContext)context, (String)"default_screen")), class_2179.method_9285((CommandContext)context, (String)"ui_definition")));
            return 0;
        }))))));
        LiteralArgumentBuilder config = class_2170.method_9247((String)"config");
        FactoryConfig.COMMON_STORAGES.forEach((k, s) -> config.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)k.toString()).then(class_2170.method_9247((String)"reload").executes(c -> {
            s.load();
            return 1;
        }))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"value", (ArgumentType)class_2179.method_9284()).executes(c -> {
            s.decodeConfigs(new Dynamic((DynamicOps)class_2509.field_11560, (Object)class_2179.method_9285((CommandContext)c, (String)"value")));
            s.sync();
            return 1;
        })))).then(class_2170.method_9247((String)"save").executes(c -> {
            s.save();
            return 1;
        }))));
        command.then((ArgumentBuilder)config);
        commandDispatcher.register(command);
    }

    public record UIDefinitionPayload(Optional<class_2960> defaultScreen, class_2487 uiDefinitionNbt) implements CommonNetwork.Payload
    {
        public static final CommonNetwork.Identifier<UIDefinitionPayload> ID = CommonNetwork.Identifier.create(FactoryAPI.createModLocation("ui_definition_s2c"), UIDefinitionPayload::decode);

        @Override
        public void apply(CommonNetwork.Payload.Context context) {
            context.executor().execute(() -> FactoryAPIClient.uiDefinitionManager.openDefaultScreenAndAddDefinition(this.defaultScreen, UIDefinitionManager.fromDynamic(ID.toString(), new Dynamic((DynamicOps)class_2509.field_11560, (Object)this.uiDefinitionNbt))));
        }

        public static UIDefinitionPayload decode(CommonNetwork.PlayBuf buf) {
            return new UIDefinitionPayload(((class_9129)buf.get()).method_37436(class_2540::method_10810), ((class_9129)buf.get()).method_10798());
        }

        @Override
        public void encode(CommonNetwork.PlayBuf buf) {
            ((class_9129)buf.get()).method_37435(this.defaultScreen, class_2540::method_10812);
            ((class_9129)buf.get()).method_10794((class_2520)this.uiDefinitionNbt);
        }

        public CommonNetwork.Identifier<UIDefinitionPayload> identifier() {
            return ID;
        }
    }

    public static class JsonArgument
    implements ArgumentType<JsonElement> {
        public static final Map<String, Field> JSON_READER_FIELDS = FactoryAPI.getAccessibleFieldsMap(JsonReader.class, "pos", "lineStart");
        private static final Collection<String> EXAMPLES = Arrays.asList("\"hello world\"", "\"\"", "\"{\"text\":\"hello world\"}", "[\"\"]");

        public static int getPos(JsonReader jsonReader) {
            try {
                return JSON_READER_FIELDS.get("pos").getInt(jsonReader) - JSON_READER_FIELDS.get("lineStart").getInt(jsonReader) + 1;
            }
            catch (IllegalAccessException var2) {
                throw new IllegalStateException("Couldn't read position of JsonReader", var2);
            }
        }

        public static JsonElement getJson(CommandContext<class_2168> commandContext, String string) {
            return (JsonElement)commandContext.getArgument(string, JsonElement.class);
        }

        public static JsonArgument json() {
            return new JsonArgument();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JsonElement parse(com.mojang.brigadier.StringReader stringReader) {
            JsonElement element;
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(stringReader.getRemaining()));
            jsonReader.setLenient(false);
            try {
                element = Streams.parse((JsonReader)jsonReader);
            }
            finally {
                stringReader.setCursor(stringReader.getCursor() + JsonArgument.getPos(jsonReader));
            }
            return element;
        }

        public Collection<String> getExamples() {
            return EXAMPLES;
        }
    }
}

