/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import net.minecraft.class_332;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.FactoryGuiMatrixStack;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.ColorUtil;
import wily.factoryapi.util.FactoryScreenUtil;

public record FactoryGuiElement(String name, boolean isHud, FactoryEvent<GuiRender> pre, FactoryEvent<GuiRender> modifiedPre, FactoryEvent<GuiRender> post, FactoryEvent<GuiRender> modifiedPost) {
    public static final FactoryGuiElement HOTBAR = new FactoryGuiElement("hotbar");
    public static final FactoryGuiElement SPECTATOR_HOTBAR = new FactoryGuiElement("spectator_hotbar");
    public static final FactoryGuiElement EFFECTS = new FactoryGuiElement("effects", false);
    public static final FactoryGuiElement SCOREBOARD = new FactoryGuiElement("scoreboard", false);
    public static final FactoryGuiElement CROSSHAIR = new FactoryGuiElement("crosshair");
    public static final FactoryGuiElement OVERLAY_MESSAGE = new FactoryGuiElement("overlay_message");
    public static final FactoryGuiElement PLAYER_HEALTH = new FactoryGuiElement("player_health");
    public static final FactoryGuiElement VEHICLE_HEALTH = new FactoryGuiElement("vehicle_health");
    public static final FactoryGuiElement EXPERIENCE_BAR = new FactoryGuiElement("experience_bar");
    public static final FactoryGuiElement LOCATOR_BAR = new FactoryGuiElement("locator_bar");
    public static final FactoryGuiElement JUMP_METER = new FactoryGuiElement("jump_meter");
    public static final FactoryGuiElement SELECTED_ITEM_NAME = new FactoryGuiElement("selected_item_name");
    public static final FactoryGuiElement SPECTATOR_TOOLTIP = new FactoryGuiElement("spectator_tooltip");
    public static final FactoryGuiElement BOSSHEALTH = new FactoryGuiElement("bosshealth", false);
    public static final FactoryGuiElement VIGNETTE = new FactoryGuiElement("vignette", false);

    public FactoryGuiElement(String name, boolean isHud) {
        this(name, isHud, GuiRender.createEvent(), GuiRender.createEvent(), GuiRender.createEvent(), GuiRender.createEvent());
    }

    public FactoryGuiElement(String name) {
        this(name, true);
    }

    public void prepareMixin(class_332 graphics, CallbackInfo info) {
        this.prepareMixin(graphics, FactoryScreenUtil.getGuiAccessor(), info);
    }

    public void finalizeMixin(class_332 graphics) {
        this.finalizeMixin(graphics, FactoryScreenUtil.getGuiAccessor());
    }

    public void prepareMixin(class_332 graphics, UIAccessor accessor, CallbackInfo info) {
        if (!this.isVisible(accessor)) {
            info.cancel();
            return;
        }
        this.prepareRender(graphics, accessor);
    }

    public void finalizeMixin(class_332 graphics, UIAccessor accessor) {
        if (!this.isVisible(accessor)) {
            return;
        }
        this.finalizeRender(graphics, accessor);
    }

    public float getOffset(String offsetName, UIAccessor accessor) {
        return accessor.getFloat(this.name + "." + offsetName, 0.0f) + (this.isHud() && accessor.getBoolean(this.name + ".hud." + offsetName, true) != false ? accessor.getFloat("hud." + offsetName, 0.0f) : 0.0f);
    }

    public float getScale(String scaleName, UIAccessor accessor) {
        return accessor.getFloat(this.name + "." + scaleName, 1.0f) * (this.isHud() && accessor.getBoolean(this.name + ".hud.scale", true) != false ? accessor.getFloat("hud." + scaleName, 1.0f) : 1.0f);
    }

    public int getColor(UIAccessor accessor) {
        return ColorUtil.mergeColors(accessor.getInteger(this.name + ".renderColor", -1), this.isHud() && accessor.getBoolean(this.name + ".hud.renderColor", true) != false ? accessor.getInteger("hud.renderColor", -1) : -1);
    }

    public void prepareRender(class_332 graphics, UIAccessor accessor) {
        ((GuiRender)this.pre.invoker).render(graphics);
        FactoryGuiMatrixStack.of(graphics.method_51448()).pushPose();
        FactoryScreenUtil.applyOffset(graphics, this.getOffset("translateX", accessor), this.getOffset("translateY", accessor), this.getOffset("translateZ", accessor));
        FactoryScreenUtil.applyScale(graphics, this.getScale("scaleX", accessor), this.getScale("scaleY", accessor), this.getScale("scaleZ", accessor));
        FactoryScreenUtil.applyOffset(graphics, this.getOffset("scaledTranslateX", accessor), this.getOffset("scaledTranslateY", accessor), this.getOffset("scaledTranslateZ", accessor));
        FactoryScreenUtil.applyColor(graphics, this.getColor(accessor));
        ((GuiRender)this.modifiedPre.invoker).render(graphics);
    }

    public void finalizeRender(class_332 graphics, UIAccessor accessor) {
        ((GuiRender)this.modifiedPost.invoker).render(graphics);
        int color = this.getColor(accessor);
        FactoryGuiMatrixStack.of(graphics.method_51448()).popPose();
        if (color != -1) {
            FactoryGuiGraphics.of(graphics).clearBlitColor();
        }
        ((GuiRender)this.post.invoker).render(graphics);
    }

    public boolean isVisible(UIAccessor accessor) {
        return accessor.getBoolean(this.name + ".isVisible", true) != false && accessor.getBoolean("isGuiVisible", true) != false;
    }

    public static interface GuiRender {
        public void render(class_332 var1);

        public static FactoryEvent<GuiRender> createEvent() {
            return new FactoryEvent<GuiRender>(e -> graphics -> e.invokeAll(guiRender -> guiRender.render(graphics)));
        }
    }
}

