/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.base.IHasIdentifier;
import wily.factoryapi.base.IPlatformHandler;
import wily.factoryapi.base.ITagSerializable;
import wily.factoryapi.util.FluidInstance;

public interface IPlatformFluidHandler
extends ITagSerializable<CompoundTag>,
IPlatformHandler,
IHasIdentifier,
IFluidHandler,
IFluidTank {
    @NotNull
    public FluidInstance getFluidInstance();

    public int getMaxFluid();

    public boolean isFluidValid(@NotNull FluidInstance var1);

    public int fill(FluidInstance var1, boolean var2);

    @NotNull
    public FluidInstance drain(FluidInstance var1, boolean var2);

    @NotNull
    public FluidInstance drain(int var1, boolean var2);

    default public int getTotalSpace() {
        return Math.max(0, this.getMaxFluid() - this.getFluidInstance().getAmount());
    }

    public void setFluid(FluidInstance var1);

    default public void setCapacity(int capacity) {
        throw new UnsupportedOperationException("This Platform Fluid Handler capacity can't be modified!");
    }

    default public String getName() {
        return this.identifier().getName() + "Tank";
    }

    @Override
    default public void deserializeTag(CompoundTag tag) {
        this.setFluid(FluidInstance.fromTag(tag));
        Tag t = (Tag)tag.f_128329_.get("capacity");
        if (t instanceof NumericTag) {
            if (t instanceof LongTag) {
                LongTag l = (LongTag)t;
                this.setCapacity(FluidInstance.getMilliBucketsFluidAmount(l.m_7046_()));
            } else if (t instanceof IntTag) {
                IntTag i = (IntTag)t;
                this.setCapacity(i.m_7047_());
            }
        }
    }

    @Override
    default public CompoundTag serializeTag() {
        CompoundTag tag = FluidInstance.toTag(this.getFluidInstance());
        tag.m_128405_("capacity", this.getMaxFluid());
        return tag;
    }

    @NotNull
    default public FluidStack getFluid() {
        return new FluidStack(this.getFluidInstance().getFluid(), this.getFluidInstance().getAmount());
    }

    default public int getFluidAmount() {
        return this.getFluid().getAmount();
    }

    default public int getCapacity() {
        return this.getMaxFluid();
    }

    default public boolean isFluidValid(FluidStack fluidStack) {
        return this.isFluidValid(FluidInstance.create(fluidStack.getFluid(), fluidStack.getAmount()));
    }

    default public int getTanks() {
        return 1;
    }

    @NotNull
    default public FluidStack getFluidInTank(int i) {
        return this.getFluid();
    }

    default public int getTankCapacity(int i) {
        return this.getCapacity();
    }

    default public boolean isFluidValid(int i, @NotNull FluidStack fluidStack) {
        return this.isFluidValid(fluidStack);
    }

    default public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return this.fill(FluidInstance.create(fluidStack.getFluid(), fluidStack.getAmount()), fluidAction.simulate());
    }

    @NotNull
    default public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        FluidInstance drained = this.drain(FluidInstance.create(fluidStack.getFluid(), fluidStack.getAmount()), fluidAction.simulate());
        return new FluidStack(drained.getFluid(), drained.getAmount());
    }

    @NotNull
    default public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
        FluidInstance drained = this.drain(i, fluidAction.simulate());
        return new FluidStack(drained.getFluid(), drained.getAmount());
    }
}

