/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.client.GuiSpriteManager;
import wily.factoryapi.base.client.GuiSpriteScaling;

public interface FactoryGuiGraphics {
    public GuiGraphics context();

    public MultiBufferSource.BufferSource getBufferSource();

    public void pushBufferSource(MultiBufferSource.BufferSource var1);

    public void popBufferSource();

    public static FactoryGuiGraphics of(GuiGraphics guiGraphics) {
        return ((Accessor)guiGraphics).getFactoryGuiGraphics();
    }

    public static GuiSpriteManager getSprites() {
        return FactoryAPIClient.sprites;
    }

    public void blit(ResourceLocation var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public void blit(ResourceLocation var1, int var2, int var3, int var4, float var5, float var6, int var7, int var8, int var9, int var10);

    public void blit(ResourceLocation var1, int var2, int var3, int var4, int var5, float var6, float var7, int var8, int var9, int var10, int var11);

    public void blit(ResourceLocation var1, int var2, int var3, float var4, float var5, int var6, int var7, int var8, int var9);

    public void blitSprite(ResourceLocation var1, int var2, int var3, int var4, int var5);

    public void blitSprite(ResourceLocation var1, int var2, int var3, int var4, int var5, int var6);

    public void blitSprite(ResourceLocation var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public void blit(int var1, int var2, int var3, int var4, int var5, TextureAtlasSprite var6);

    default public void blitSprite(ResourceLocation resourceLocation, int textureWidth, int textureHeight, int uvX, int uvY, int x, int y, int width, int height) {
        this.blitSprite(resourceLocation, textureWidth, textureHeight, uvX, uvY, x, y, 0, width, height);
    }

    public void enableScissor(int var1, int var2, int var3, int var4, boolean var5);

    default public void enableScissor(int x, int y, int xd, int yd) {
        this.enableScissor(x, y, xd, yd, true);
    }

    default public void blitNineSlicedSprite(TextureAtlasSprite textureAtlasSprite, GuiSpriteScaling.NineSlice nineSlice, int x, int y, int z, int width, int height) {
        GuiSpriteScaling.NineSlice.Border border = nineSlice.border();
        int n = Math.min(border.left(), width / 2);
        int o = Math.min(border.right(), width / 2);
        int p = Math.min(border.top(), height / 2);
        int q = Math.min(border.bottom(), height / 2);
        if (width == nineSlice.width() && height == nineSlice.height()) {
            this.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), 0, 0, x, y, z, width, height);
        } else if (height == nineSlice.height()) {
            this.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), 0, 0, x, y, z, n, height);
            this.blitTiledSprite(textureAtlasSprite, x + n, y, z, width - o - n, height, n, 0, nineSlice.width() - o - n, nineSlice.height(), nineSlice.width(), nineSlice.height());
            this.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), nineSlice.width() - o, 0, x + width - o, y, z, o, height);
        } else if (width == nineSlice.width()) {
            this.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), 0, 0, x, y, z, width, p);
            this.blitTiledSprite(textureAtlasSprite, x, y + p, z, width, height - q - p, 0, p, nineSlice.width(), nineSlice.height() - q - p, nineSlice.width(), nineSlice.height());
            this.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), 0, nineSlice.height() - q, x, y + height - q, z, width, q);
        } else {
            this.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), 0, 0, x, y, z, n, p);
            this.blitTiledSprite(textureAtlasSprite, x + n, y, z, width - o - n, p, n, 0, nineSlice.width() - o - n, p, nineSlice.width(), nineSlice.height());
            this.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), nineSlice.width() - o, 0, x + width - o, y, z, o, p);
            this.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), 0, nineSlice.height() - q, x, y + height - q, z, n, q);
            this.blitTiledSprite(textureAtlasSprite, x + n, y + height - q, z, width - o - n, q, n, nineSlice.height() - q, nineSlice.width() - o - n, q, nineSlice.width(), nineSlice.height());
            this.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), nineSlice.width() - o, nineSlice.height() - q, x + width - o, y + height - q, z, o, q);
            this.blitTiledSprite(textureAtlasSprite, x, y + p, z, n, height - q - p, 0, p, n, nineSlice.height() - q - p, nineSlice.width(), nineSlice.height());
            this.blitTiledSprite(textureAtlasSprite, x + n, y + p, z, width - o - n, height - q - p, n, p, nineSlice.width() - o - n, nineSlice.height() - q - p, nineSlice.width(), nineSlice.height());
            this.blitTiledSprite(textureAtlasSprite, x + width - o, y + p, z, n, height - q - p, nineSlice.width() - o, p, o, nineSlice.height() - q - p, nineSlice.width(), nineSlice.height());
        }
    }

    public void blitSprite(TextureAtlasSprite var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public void blitSprite(TextureAtlasSprite var1, int var2, int var3, int var4, int var5, int var6);

    default public void blitTiledSprite(TextureAtlasSprite textureAtlasSprite, int i, int j, int k, int l, int m, int n, int o, int p, int q, int r, int s) {
        if (l <= 0 || m <= 0) {
            return;
        }
        if (p <= 0 || q <= 0) {
            throw new IllegalArgumentException("Tiled sprite texture size must be positive, got " + p + "x" + q);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureAtlasSprite.m_247685_());
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix4f = this.context().m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        for (int t = 0; t < l; t += p) {
            int u = Math.min(p, l - t);
            for (int v = 0; v < m; v += q) {
                int w = Math.min(q, m - v);
                this.addBlitSpriteQuad(textureAtlasSprite, bufferBuilder, matrix4f, r, s, n, o, i + t, j + v, k, u, w);
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    private void addBlitSpriteQuad(TextureAtlasSprite textureAtlasSprite, BufferBuilder bufferBuilder, Matrix4f matrix4f, int i, int j, int k, int l, int m, int n, int o, int p, int q) {
        this.addBlitQuad(bufferBuilder, matrix4f, m, m + p, n, n + q, o, textureAtlasSprite.m_118367_((double)((float)k / (float)i)), textureAtlasSprite.m_118367_((double)((float)(k + p) / (float)i)), textureAtlasSprite.m_118393_((double)((float)l / (float)j)), textureAtlasSprite.m_118393_((double)((float)(l + q) / (float)j)));
    }

    private void addBlitQuad(BufferBuilder bufferBuilder, Matrix4f matrix4f, int i, int j, int k, int l, int m, float f, float g, float h, float n) {
        bufferBuilder.m_252986_(matrix4f, (float)i, (float)k, (float)m).m_7421_(f, h).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)i, (float)l, (float)m).m_7421_(f, n).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)j, (float)l, (float)m).m_7421_(g, n).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)j, (float)k, (float)m).m_7421_(g, h).m_5752_();
    }

    public void setColor(int var1, boolean var2);

    public void setColor(float var1, float var2, float var3, float var4, boolean var5);

    default public void setColor(int color) {
        this.setColor(color, false);
    }

    default public void setColor(float r, float g, float b, float a) {
        this.setColor(r, g, b, a, false);
    }

    public float[] getColor();

    default public void clearColor(boolean changeBlend) {
        this.setColor(1.0f, 1.0f, 1.0f, 1.0f, changeBlend);
    }

    default public void clearColor() {
        this.clearColor(false);
    }

    @Deprecated
    public void disableDepthTest();

    @Deprecated
    public void enableDepthTest();

    public static interface Accessor {
        public FactoryGuiGraphics getFactoryGuiGraphics();
    }

    public static interface AtlasAccessor {
        public static AtlasAccessor of(TextureAtlas atlas) {
            return (AtlasAccessor)atlas;
        }

        public Map<ResourceLocation, TextureAtlasSprite> getTexturesByName();
    }
}

