/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.FactoryGuiMatrixStack;
import wily.factoryapi.base.client.FactoryOptions;
import wily.factoryapi.base.client.UIDefinition;
import wily.factoryapi.base.client.WidgetAccessor;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.factoryapi.util.VariableResolver;
import wily.factoryapi.util.VariablesMap;

public interface UIAccessor
extends UIDefinition,
VariableResolver {
    public static UIAccessor of(Screen screen) {
        return (UIAccessor)screen;
    }

    public static UIAccessor of(Gui gui) {
        return (UIAccessor)gui;
    }

    @Nullable
    public Screen getScreen();

    default public void reloadUI() {
        this.beforeInit();
        this.getChildrenRenderables().clear();
        this.afterInit();
    }

    public boolean initialized();

    @Override
    default public void beforeInit(UIAccessor accessor) {
        Inventory inventory;
        this.getElements().clear();
        this.putStaticElement("windowWidth", Minecraft.m_91087_().m_91268_().m_85441_());
        this.putStaticElement("windowHeight", Minecraft.m_91087_().m_91268_().m_85442_());
        this.putStaticElement("width", Minecraft.m_91087_().m_91268_().m_85445_());
        this.putStaticElement("height", Minecraft.m_91087_().m_91268_().m_85446_());
        this.getElements().put("hasScreen", () -> Minecraft.m_91087_().f_91080_ != null);
        if (this.getChildrenRenderables() != null) {
            this.getElements().put("renderablesCount", this.getChildrenRenderables()::size);
        }
        FactoryAPIPlatform.getMods().forEach(i -> this.putStaticElement("loadedMods." + i.getId(), true));
        ServerData serverData = Minecraft.m_91087_().m_91089_();
        if (serverData != null) {
            this.putStaticElement("serverIp." + serverData.f_105363_, true);
        }
        Inventory inventory2 = inventory = Minecraft.m_91087_().f_91074_ == null ? null : Minecraft.m_91087_().f_91074_.m_150109_();
        if (inventory != null) {
            int index;
            NonNullList items = inventory.f_35974_;
            int i2 = 0;
            while (i2 < items.size()) {
                index = i2++;
                this.getElements().put("inventory." + index, () -> UIAccessor.lambda$beforeInit$2((List)items, index));
            }
            i2 = 0;
            while (i2 < inventory.f_35975_.size()) {
                index = i2++;
                this.getElements().put("inventory.armor." + index, () -> inventory.f_35975_.get(index));
            }
            this.getElements().put("inventory.offhand", () -> inventory.f_35976_.get(0));
        }
        this.putSupplierComponent("username", () -> Component.m_237113_((String)Minecraft.m_91087_().m_91094_().m_92546_()));
        Screen screen = this.getScreen();
        if (screen instanceof MenuAccess) {
            MenuAccess access = (MenuAccess)screen;
            this.getElements().put("slotsCount", () -> ((NonNullList)access.m_6262_().f_38839_).size());
            for (Slot slot : access.m_6262_().f_38839_) {
                this.getElements().put("menu.slot." + slot.m_150661_(), () -> ((Slot)slot).m_7993_());
            }
        }
        this.getDefinitions().clear();
        FactoryAPIClient.uiDefinitionManager.applyStatic(accessor);
        this.getDefinitions().addAll(this.getStaticDefinitions());
        FactoryAPIClient.uiDefinitionManager.apply(accessor);
        UIDefinition.super.beforeInit(accessor);
    }

    default public void beforeInit() {
        this.beforeInit(this);
    }

    default public void afterInit() {
        this.afterInit(this);
        if (((Boolean)FactoryOptions.UI_DEFINITION_LOGGING.get()).booleanValue()) {
            FactoryAPI.LOGGER.warn(this.getElements());
        }
    }

    default public void beforeTick() {
        this.beforeTick(this);
    }

    default public void afterTick() {
        this.afterTick(this);
    }

    public List<GuiEventListener> getChildren();

    public List<Renderable> getChildrenRenderables();

    public <T extends GuiEventListener> T removeChild(T var1);

    public <T extends GuiEventListener> T addChild(int var1, T var2, boolean var3, boolean var4);

    default public <T extends GuiEventListener> T addChild(int renderableIndex, T listener) {
        return this.addChild(renderableIndex, listener, true, true);
    }

    default public <T extends GuiEventListener> T addChild(String name, T listener) {
        return this.addChild(this.getInteger(name + ".order", this.getChildrenRenderables().size()), listener);
    }

    default public <T extends Renderable> T addRenderable(T renderable) {
        return this.addRenderable(this.getChildrenRenderables().size(), renderable);
    }

    default public <T extends Renderable> T addRenderable(int index, T renderable) {
        this.getChildrenRenderables().add(Math.min(Math.max(0, index), this.getChildrenRenderables().size()), renderable);
        return renderable;
    }

    default public <T extends Renderable> T addRenderable(String name, T renderable) {
        return this.addRenderable(this.getInteger(name + ".order", this.getChildrenRenderables().size()), renderable);
    }

    public VariablesMap<String, ArbitrarySupplier<?>> getElements();

    default public <E> E putStaticElement(String name, E e) {
        this.getElements().put(name, ArbitrarySupplier.of(e));
        return e;
    }

    default public <E> E putBearer(String name, Bearer<E> e, Function<Object, E> convertOldValue) {
        ArbitrarySupplier oldElement = this.getElements().put(name, e);
        if (oldElement != null) {
            oldElement.map(convertOldValue::apply).ifPresent(e::set);
        }
        return (E)e.get();
    }

    default public <E> E putBearer(String name, Bearer<E> e) {
        return (E)this.putBearer(name, e, o -> o);
    }

    default public Integer putIntegerBearer(String name, Bearer<Integer> e) {
        return this.putBearer(name, e, o -> {
            Integer n;
            if (o instanceof Number) {
                Number n2 = (Number)o;
                n = n2.intValue();
            } else if (o instanceof String) {
                String s = (String)o;
                n = Integer.parseInt(s);
            } else {
                n = null;
            }
            return n;
        });
    }

    default public <E extends AbstractWidget> E putWidget(String name, E e) {
        this.putBearer(name + ".message", Bearer.of(() -> e.m_6035_(), arg_0 -> e.m_93666_(arg_0)));
        this.getElement(name + ".tooltip", Component.class).ifPresent(c -> e.m_257544_(Tooltip.m_257550_((Component)c)));
        this.putBearer(name + ".spriteOverride", Bearer.of(WidgetAccessor.of(e)::getSpriteOverride, WidgetAccessor.of(e)::setSpriteOverride));
        this.putBearer(name + ".highlightedSpriteOverride", Bearer.of(WidgetAccessor.of(e)::getSpriteOverride, WidgetAccessor.of(e)::setHighlightedSpriteOverride));
        this.putBearer(name + ".onPressOverride", Bearer.of(WidgetAccessor.of(e)::getOnPressOverride, WidgetAccessor.of(e)::setOnPressOverride));
        WidgetAccessor.of(e).setVisibility(this.getElement(name + ".isVisible", Boolean.class));
        return this.putLayoutElement(name, e, arg_0 -> e.m_93674_(arg_0), WidgetAccessor.of(e)::setHeight);
    }

    default public Component putComponent(String name, Component component) {
        this.putStaticElement(name, component);
        this.putStaticElement(name + ".width", Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component));
        return component;
    }

    default public void putSupplierComponent(String name, ArbitrarySupplier<Component> component) {
        this.getElements().put(name, component);
        this.getElements().put(name + ".width", component.map(c -> Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)c)));
    }

    default public Vec3 putVec3(String name, Vec3 vec3) {
        this.putStaticElement(name, vec3);
        this.putStaticElement(name + ".x", vec3.m_7096_());
        this.putStaticElement(name + ".y", vec3.m_7098_());
        this.putStaticElement(name + ".z", vec3.m_7094_());
        return vec3;
    }

    default public Vec2 putVec2(String name, Vec2 offset) {
        this.putStaticElement(name, offset);
        this.putStaticElement(name + ".x", Float.valueOf(offset.f_82470_));
        this.putStaticElement(name + ".y", Float.valueOf(offset.f_82471_));
        return offset;
    }

    default public Renderable createModifiableRenderable(String name, Renderable renderable) {
        return (guiGraphics, i, j, f) -> {
            int amount = this.getInteger(name + ".amount", 1);
            for (int i1 = 0; i1 < amount; ++i1) {
                ArbitrarySupplier<?> patt0$temp = this.getElements().get(name + ".index");
                if (patt0$temp instanceof Bearer) {
                    Bearer b = (Bearer)patt0$temp;
                    b.secureCast(Integer.class).set(i1);
                }
                FactoryGuiMatrixStack.of(guiGraphics.m_280168_()).pushPose();
                int color = this.getInteger(name + ".renderColor", -1);
                FactoryScreenUtil.enableBlend();
                FactoryGuiGraphics.of(guiGraphics).setColor(color);
                FactoryGuiMatrixStack.of(guiGraphics.m_280168_()).translate(this.getDouble(name + ".translateX", 0.0), this.getDouble(name + ".translateY", 0.0), this.getDouble(name + ".translateZ", 0.0));
                FactoryGuiMatrixStack.of(guiGraphics.m_280168_()).scale(this.getFloat(name + ".scaleX", 1.0f), this.getFloat(name + ".scaleY", 1.0f), this.getFloat(name + ".scaleZ", 1.0f));
                renderable.m_88315_(guiGraphics, i, j, f);
                FactoryGuiMatrixStack.of(guiGraphics.m_280168_()).popPose();
                FactoryScreenUtil.disableBlend();
                FactoryGuiGraphics.of(guiGraphics).clearColor();
            }
        };
    }

    default public <E extends LayoutElement> E putLayoutElement(String name, E e, Consumer<Integer> setWidth, Consumer<Integer> setHeight) {
        this.putIntegerBearer(name + ".x", Bearer.of(() -> e.m_252754_(), arg_0 -> e.m_252865_(arg_0)));
        this.putIntegerBearer(name + ".y", Bearer.of(() -> e.m_252907_(), arg_0 -> e.m_253211_(arg_0)));
        this.putIntegerBearer(name + ".width", Bearer.of(() -> e.m_5711_(), setWidth));
        this.putIntegerBearer(name + ".height", Bearer.of(() -> e.m_93694_(), setHeight));
        return this.putStaticElement(name, e);
    }

    default public String replaceValidElementValues(String s) {
        this.getElements().updatePattern();
        Matcher matcher = this.getElements().getPattern().matcher(s);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String key = matcher.group(1);
            matcher.appendReplacement(result, String.valueOf(this.getElements().get(key).get()));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    default public <V> ArbitrarySupplier<V> getElement(String name, Class<V> valueClass) {
        return this.getElements().getOrDefault(name, ArbitrarySupplier.empty()).secureCast(valueClass);
    }

    default public ArbitrarySupplier<?> getElement(String name) {
        return this.getElements().getOrDefault(name, ArbitrarySupplier.empty());
    }

    default public ArbitrarySupplier<Boolean> getBooleanElement(String name) {
        return this.getElement(name, Boolean.class);
    }

    default public ArbitrarySupplier<Integer> getIntegerElement(String name) {
        return this.getElement(name, Number.class).map(Number::intValue);
    }

    default public <V> V getElementValue(String name, V defaultValue, Class<V> valueClass) {
        Object value;
        ArbitrarySupplier<?> element = this.getElements().get(name);
        return element != null && valueClass.isInstance(value = element.get()) ? valueClass.cast(value) : defaultValue;
    }

    default public int getInteger(String name, int defaultValue) {
        return this.getElementValue(name, defaultValue, Number.class).intValue();
    }

    default public double getDouble(String name, double defaultValue) {
        return this.getElementValue(name, defaultValue, Number.class).doubleValue();
    }

    default public float getFloat(String name, float defaultValue) {
        return this.getElementValue(name, Float.valueOf(defaultValue), Number.class).floatValue();
    }

    @Override
    default public Boolean getBoolean(String name, Boolean defaultValue) {
        return this.getElementValue(name, defaultValue, Boolean.class);
    }

    default public Boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    default public ResourceLocation getResourceLocation(String name, ResourceLocation defaultValue) {
        return this.getElementValue(name, defaultValue, ResourceLocation.class);
    }

    default public ResourceLocation getResourceLocation(String name) {
        return this.getResourceLocation(name, null);
    }

    default public ItemStack getItemStack(String name) {
        return this.getElementValue(name, ItemStack.f_41583_, ItemStack.class);
    }

    default public ItemStack getItemStack(String name, ItemStack defaultValue) {
        return this.getElementValue(name, defaultValue, ItemStack.class);
    }

    default public Component getComponent(String name, Component defaultValue) {
        return this.getElementValue(name, defaultValue, Component.class);
    }

    default public Component getComponent(String name) {
        return this.getComponent(name, null);
    }

    default public Vec3 getVec3(String name, Vec3 defaultValue) {
        return this.getElementValue(name, defaultValue, Vec3.class);
    }

    default public Vec3 getVec3(String name) {
        return this.getVec3(name, null);
    }

    @Override
    default public Number getNumber(String name, Number defaultValue) {
        return this.getElementValue(name, defaultValue, Number.class);
    }

    public static UIAccessor createRenderablesWrapper(final UIAccessor accessor, final List<Renderable> renderables) {
        return new UIAccessor(){

            @Override
            @Nullable
            public Screen getScreen() {
                return accessor.getScreen();
            }

            @Override
            public List<UIDefinition> getDefinitions() {
                return accessor.getDefinitions();
            }

            @Override
            public void reloadUI() {
                accessor.reloadUI();
            }

            @Override
            public boolean initialized() {
                return accessor.initialized();
            }

            @Override
            public List<UIDefinition> getStaticDefinitions() {
                return accessor.getStaticDefinitions();
            }

            @Override
            public List<GuiEventListener> getChildren() {
                return Collections.emptyList();
            }

            @Override
            public List<Renderable> getChildrenRenderables() {
                return renderables;
            }

            @Override
            public <T extends GuiEventListener> T removeChild(T widget) {
                if (widget instanceof Renderable) {
                    renderables.remove(widget);
                }
                return widget;
            }

            @Override
            public <T extends GuiEventListener> T addChild(int renderableIndex, T listener, boolean isRenderable, boolean isNarratable) {
                if (isRenderable && listener instanceof Renderable) {
                    Renderable r = (Renderable)listener;
                    renderables.add(renderableIndex, r);
                }
                return listener;
            }

            @Override
            public VariablesMap<String, ArbitrarySupplier<?>> getElements() {
                return accessor.getElements();
            }
        };
    }

    private static /* synthetic */ Object lambda$beforeInit$2(List items, int index) {
        return items.get(index);
    }
}

