/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client.drawable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import wily.factoryapi.base.client.FactoryGuiMatrixStack;
import wily.factoryapi.base.client.drawable.IFactoryDrawableType;
import wily.factoryapi.util.FluidInstance;

public abstract class AbstractDrawableStatic<D extends AbstractDrawableStatic<D, T>, T extends IFactoryDrawableType>
extends Rect2i
implements IFactoryDrawableType,
Renderable {
    public T drawable;
    protected final List<Component> tooltips = new ArrayList<Component>();
    public boolean hovered = false;
    protected Minecraft mc = Minecraft.m_91087_();
    public Supplier<Boolean> visible = () -> true;
    protected IFactoryDrawableType overlay;

    public AbstractDrawableStatic(T drawable, int posX, int posY) {
        super(posX, posY, drawable.width(), drawable.height());
        this.drawable = drawable;
    }

    public D overlay(IFactoryDrawableType overlay) {
        this.overlay = overlay;
        return (D)this;
    }

    public D visible(Supplier<Boolean> visible) {
        this.visible = visible;
        return (D)this;
    }

    public D tooltip(Component component) {
        this.tooltips.add(component);
        return (D)this;
    }

    public D tooltips(List<Component> components) {
        this.tooltips.addAll(components);
        return (D)this;
    }

    public D clearTooltips() {
        this.tooltips.clear();
        return (D)this;
    }

    public void draw(GuiGraphics graphics) {
        this.draw(graphics, this.m_110085_(), this.m_110086_());
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y) {
        IFactoryDrawableType.super.draw(graphics, x, y);
        FactoryGuiMatrixStack.of(graphics.m_280168_()).pushPose();
        FactoryGuiMatrixStack.of(graphics.m_280168_()).translate(0.0, 0.0, 1.0);
        if (this.overlay != null) {
            int n;
            int n2;
            IFactoryDrawableType iFactoryDrawableType = this.overlay;
            if (iFactoryDrawableType instanceof AbstractDrawableStatic) {
                AbstractDrawableStatic d = (AbstractDrawableStatic)iFactoryDrawableType;
                n2 = d.m_110085_();
            } else {
                n2 = 0;
            }
            int dX = n2;
            IFactoryDrawableType iFactoryDrawableType2 = this.overlay;
            if (iFactoryDrawableType2 instanceof AbstractDrawableStatic) {
                AbstractDrawableStatic d = (AbstractDrawableStatic)iFactoryDrawableType2;
                n = d.m_110086_();
            } else {
                n = 0;
            }
            int dY = n;
            this.overlay.draw(graphics, x + dX + (this.width() - this.overlay.width()) / 2, y + dY + (this.height() - this.overlay.height()) / 2);
        }
        FactoryGuiMatrixStack.of(graphics.m_280168_()).popPose();
    }

    @Override
    public boolean isSprite() {
        return this.drawable.isSprite();
    }

    public void drawAsFluidTank(GuiGraphics graphics, FluidInstance instance, int capacity, boolean hasColor) {
        this.drawable.drawAsFluidTank(graphics, this.m_110085_(), this.m_110086_(), instance, capacity, hasColor);
    }

    public boolean inMouseLimit(double mouseX, double mouseY) {
        return this.drawable.inMouseLimit(mouseX, mouseY, this.m_110085_(), this.m_110086_());
    }

    @Override
    public ResourceLocation texture() {
        return this.drawable.texture();
    }

    @Override
    public int width() {
        return this.m_110090_();
    }

    @Override
    public int height() {
        return this.m_110091_();
    }

    @Override
    public int uvX() {
        return this.drawable.uvX();
    }

    @Override
    public int uvY() {
        return this.drawable.uvY();
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        if (!this.visible.get().booleanValue()) {
            return;
        }
        this.hovered = this.inMouseLimit(i, j);
        this.draw(guiGraphics);
        if (this.hovered && !this.tooltips.isEmpty()) {
            guiGraphics.m_280666_(this.mc.f_91062_, this.tooltips, i, j);
        }
    }
}

