/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.mojang.blaze3d.platform.InputConstants;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.ICraftyEnergyStorage;
import wily.factoryapi.base.IPlatformEnergyStorage;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.util.FluidInstance;

public class StorageStringUtil {
    public static final String DEFAULT_CRAFTY_ENERGY = "tooltip.factory_api.crafty_energy";
    public static final String DEFAULT_ENERGY_SUFFIX = StorageStringUtil.getBetweenParenthesis(FactoryAPIPlatform.getPlatformEnergyComponent().getString());
    public static final String DEFAULT_FLUID = "tooltip.factory_api.fluid";
    protected static String fluidMeasure = I18n.m_118938_((String)"tooltip.factory_api.fluid", (Object[])new Object[]{" "});
    protected static String milliFluid = I18n.m_118938_((String)"tooltip.factory_api.fluid", (Object[])new Object[]{" m"});
    protected static String kiloFluid = I18n.m_118938_((String)"tooltip.factory_api.fluid", (Object[])new Object[]{" k"});
    public static String energyMeasure = " " + DEFAULT_ENERGY_SUFFIX;
    public static String kiloEnergy = " k" + DEFAULT_ENERGY_SUFFIX;
    public static String megaEnergy = " M" + DEFAULT_ENERGY_SUFFIX;
    public static String CYMeasure = I18n.m_118938_((String)"tooltip.factory_api.crafty_energy", (Object[])new Object[]{" "});
    public static String kiloCY = I18n.m_118938_((String)"tooltip.factory_api.crafty_energy", (Object[])new Object[]{" k"});
    public static String megaCY = I18n.m_118938_((String)"tooltip.factory_api.crafty_energy", (Object[])new Object[]{" M"});

    public static MutableComponent getEnergyTooltip(String key, IPlatformEnergyStorage cell) {
        return StorageStringUtil.getEnergyTooltip(key, cell, energyMeasure, kiloEnergy, megaEnergy);
    }

    public static MutableComponent getEnergyTooltip(String key, ICraftyEnergyStorage cell) {
        return StorageStringUtil.getEnergyTooltip(key, cell, CYMeasure, kiloCY, megaCY);
    }

    public static MutableComponent getEnergyTooltip(String key, IPlatformEnergyStorage cell, String ... measures) {
        return Component.m_237110_((String)key, (Object[])new Object[]{StorageStringUtil.getStorageAmount(cell.getEnergyStored(), StorageStringUtil.isShiftKeyDown(), measures), StorageStringUtil.getStorageAmount(cell.getMaxEnergyStored(), false, measures)}).m_130948_(cell.getComponentStyle());
    }

    public static MutableComponent getMaxCraftyTransferTooltip(int energyPerTick) {
        return Component.m_237110_((String)"tooltip.factory_api.max_transfer", (Object[])new Object[]{StorageStringUtil.getStorageAmount(energyPerTick, StorageStringUtil.isShiftKeyDown(), CYMeasure, kiloCY, megaCY)});
    }

    public static MutableComponent getMaxEnergyTransferTooltip(int energyPerTick) {
        return Component.m_237110_((String)"tooltip.factory_api.max_transfer", (Object[])new Object[]{StorageStringUtil.getStorageAmount(energyPerTick, StorageStringUtil.isShiftKeyDown(), energyMeasure, kiloEnergy, megaEnergy)}).m_130940_(ChatFormatting.AQUA);
    }

    public static MutableComponent getMaxFluidTransferTooltip(long fluidPerTick) {
        return Component.m_237110_((String)"tooltip.factory_api.max_transfer", (Object[])new Object[]{StorageStringUtil.getStorageAmount(fluidPerTick, StorageStringUtil.isShiftKeyDown(), milliFluid, fluidMeasure, kiloFluid)}).m_130940_(ChatFormatting.GRAY);
    }

    public static List<Component> getCompleteEnergyTooltip(String key, @Nullable Component burned, ICraftyEnergyStorage cell) {
        ArrayList<Component> list = new ArrayList<Component>(List.of());
        if (burned == null || !cell.getStoredTier().isBurned()) {
            list.add((Component)StorageStringUtil.getEnergyTooltip(key, cell));
        } else {
            list.add((Component)burned.m_6881_().m_130940_(ChatFormatting.DARK_RED));
        }
        list.add((Component)cell.getStoredTier().getEnergyTierComponent(true));
        if (StorageStringUtil.isShiftKeyDown()) {
            list.add((Component)cell.getSupportedTier().getEnergyTierComponent(false));
        }
        return list;
    }

    public static List<Component> getCompleteEnergyTooltip(String key, ICraftyEnergyStorage cell) {
        return StorageStringUtil.getCompleteEnergyTooltip(key, null, cell);
    }

    public static Component getFluidTooltip(String key, IPlatformFluidHandler tank) {
        return StorageStringUtil.getFluidTooltip(key, tank, true);
    }

    public static Component getFluidTooltip(String key, IPlatformFluidHandler tank, boolean showEmpty) {
        return StorageStringUtil.getFluidTooltip(key, tank.getFluidInstance(), tank.getMaxFluid(), showEmpty).m_130940_(tank.identifier().color());
    }

    public static MutableComponent getFluidTooltip(String key, FluidInstance instance, long maxFluid, boolean showEmpty) {
        if (instance.isEmpty() && !StorageStringUtil.isShiftKeyDown() && showEmpty) {
            return Component.m_237115_((String)"tooltip.factory_api.empty").m_130940_(ChatFormatting.GRAY);
        }
        return Component.m_237110_((String)key, (Object[])new Object[]{instance.getName(), StorageStringUtil.getStorageAmount(instance.getAmount(), StorageStringUtil.isShiftKeyDown(), milliFluid, fluidMeasure, kiloFluid), StorageStringUtil.getStorageAmount(maxFluid, false, milliFluid, fluidMeasure, kiloFluid)});
    }

    public static String getStorageAmount(long content, boolean additionalBool, String ... measures) {
        if (content == Integer.MAX_VALUE) {
            return "\u221e";
        }
        Object amount = "";
        for (int i = measures.length - 1; i >= 1; --i) {
            float min = (float)Math.pow(1000.0, i);
            if (!((float)content >= min)) continue;
            amount = StorageStringUtil.formatMinAmount((float)content / min) + measures[i];
            break;
        }
        if (additionalBool || content < 1000L) {
            amount = StorageStringUtil.formatAmount(content) + measures[0];
        }
        return amount;
    }

    public static String formatAmount(long i) {
        return String.format("%,d", i).replace(',', '.');
    }

    public static String formatMinAmount(float i) {
        return new DecimalFormat("0.####").format(Float.parseFloat(String.format(Locale.US, "%.1f", Float.valueOf(i))));
    }

    public static String getBetweenParenthesis(String name) {
        String[] s = name.split(" ");
        return s[s.length - 1].replaceAll("[()]", "");
    }

    public static boolean isShiftKeyDown() {
        return StorageStringUtil.isKeyDown(340) || StorageStringUtil.isKeyDown(344);
    }

    public static boolean isKeyDown(int glfw) {
        InputConstants.Key key = InputConstants.Type.KEYSYM.m_84895_(glfw);
        int keyCode = key.m_84873_();
        if (keyCode != InputConstants.f_84822_.m_84873_()) {
            try {
                if (key.m_84868_() == InputConstants.Type.KEYSYM) {
                    return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keyCode);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

