/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi;

import com.mojang.brigadier.arguments.ArgumentType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.mixin.command.ArgumentTypesAccessor;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3288;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.impl.SimpleItemEnergyStorageImpl;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.ItemContainerPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.FactoryEnergyStorage;
import wily.factoryapi.base.FactoryFluidHandler;
import wily.factoryapi.base.FactoryItemFluidHandler;
import wily.factoryapi.base.FactoryItemHandler;
import wily.factoryapi.base.FactoryStorage;
import wily.factoryapi.base.ICraftyEnergyStorage;
import wily.factoryapi.base.ICraftyStorageItem;
import wily.factoryapi.base.IEnergyStorageItem;
import wily.factoryapi.base.IFactoryStorage;
import wily.factoryapi.base.IFluidHandlerItem;
import wily.factoryapi.base.IModifiableTransportHandler;
import wily.factoryapi.base.IPlatformEnergyStorage;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.IPlatformHandler;
import wily.factoryapi.base.IPlatformItemHandler;
import wily.factoryapi.base.RegisterListing;
import wily.factoryapi.base.SideList;
import wily.factoryapi.base.SimpleItemCraftyStorage;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.base.fabric.CraftyEnergyStorage;
import wily.factoryapi.base.fabric.FabricEnergyStoragePlatform;
import wily.factoryapi.util.ListMap;
import wily.factoryapi.util.ModInfo;

public interface FactoryAPIPlatform {
    public static final Map<IPlatformHandler, SideList<? super IModifiableTransportHandler>> filteredHandlersCache = new ConcurrentHashMap<IPlatformHandler, SideList<? super IModifiableTransportHandler>>();
    public static final Map<class_2586, IFactoryStorage> platformStorageWrappersCache = new ConcurrentHashMap<class_2586, IFactoryStorage>();
    public static final ListMap<String, ModInfo> MOD_INFOS = new ListMap();

    public static class_2561 getPlatformEnergyComponent() {
        return class_2561.method_43471((String)"energy.factory_api.fabric").method_27692(class_124.field_1065);
    }

    public static <T> T getRegistryValue(class_2960 location, class_2378<T> registry) {
        return (T)registry.method_10223(location);
    }

    public static <T> Optional<class_6880.class_6883<T>> getRegistryValue(class_5455 access, class_5321<T> resourceKey) {
        return access.method_46762(class_5321.method_29180((class_2960)resourceKey.method_41185())).method_46746(resourceKey);
    }

    public static class_4970.class_2251 setupBlockProperties(class_4970.class_2251 properties, RegisterListing.Holder<? extends class_2248> blockHolder) {
        return FactoryAPIPlatform.setupBlockProperties(properties, blockHolder.getId());
    }

    public static class_4970.class_2251 setupBlockProperties(class_4970.class_2251 properties, class_2960 id) {
        return properties;
    }

    public static class_1792.class_1793 setupItemProperties(class_1792.class_1793 properties, RegisterListing.Holder<? extends class_1792> itemHolder) {
        return FactoryAPIPlatform.setupItemProperties(properties, itemHolder.getId());
    }

    public static class_1792.class_1793 setupItemProperties(class_1792.class_1793 properties, class_2960 id) {
        return properties;
    }

    public static class_1792.class_1793 setupBlockItemProperties(class_1792.class_1793 properties, RegisterListing.Holder<? extends class_2248> blockHolder) {
        return FactoryAPIPlatform.setupBlockItemProperties(properties, blockHolder.getId());
    }

    public static class_1792.class_1793 setupBlockItemProperties(class_1792.class_1793 properties, class_2960 id) {
        return properties;
    }

    public static <T extends class_2586> class_2591<T> createBlockEntityType(BlockEntitySupplier<T> supplier, class_2248 ... blocks) {
        return class_2591.class_2592.method_20528(supplier::create, (class_2248[])blocks).method_11034(null);
    }

    public static IPlatformFluidHandler getItemFluidHandler(class_1799 container) {
        ContainerItemContext context = ItemContainerPlatform.modifiableStackContext(container);
        Storage handStorage = (Storage)FluidStorage.ITEM.find(container, (Object)context);
        if (handStorage instanceof IPlatformFluidHandler) {
            IPlatformFluidHandler p = (IPlatformFluidHandler)handStorage;
            return p;
        }
        class_1792 class_17922 = container.method_7909();
        if (class_17922 instanceof IFluidHandlerItem) {
            IFluidHandlerItem f = (IFluidHandlerItem)class_17922;
            return FactoryAPIPlatform.createItemFluidHandler(f, container);
        }
        return handStorage != null ? () -> handStorage : null;
    }

    public static class_5455 getRegistryAccess() {
        return FactoryAPI.currentServer == null || FactoryAPIPlatform.isClient() && FactoryAPIClient.hasLevel() ? FactoryAPIClient.getRegistryAccess() : FactoryAPI.currentServer.method_30611();
    }

    public static MinecraftServer getEntityServer(class_1297 entity) {
        return entity.method_37908().method_8503();
    }

    public static IPlatformEnergyStorage getItemEnergyStorage(class_1799 stack) {
        ContainerItemContext context = ItemContainerPlatform.modifiableStackContext(stack);
        EnergyStorage handStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)context);
        if (handStorage instanceof IPlatformEnergyStorage) {
            IPlatformEnergyStorage p = (IPlatformEnergyStorage)handStorage;
            return p;
        }
        if (stack.method_7909() instanceof IEnergyStorageItem) {
            return FactoryAPIPlatform.getItemEnergyStorage(stack, context);
        }
        return handStorage != null ? () -> handStorage : null;
    }

    public static ICraftyEnergyStorage getItemCraftyEnergyStorage(class_1799 stack) {
        ICraftyEnergyStorage craftyStorage = (ICraftyEnergyStorage)CraftyEnergyStorage.ITEM.find(stack, (Object)ItemContainerPlatform.modifiableStackContext(stack));
        if (craftyStorage == null) {
            return FactoryAPIPlatform.getItemCraftyEnergyStorageApi(stack);
        }
        return craftyStorage;
    }

    public static IPlatformFluidHandler createItemFluidHandler(IFluidHandlerItem<?> f, class_1799 container) {
        return new FactoryItemFluidHandler(f.getCapacity(), container, f::isFluidValid, f.getTransport());
    }

    public static IPlatformEnergyStorage getItemEnergyStorage(class_1799 container, ContainerItemContext context) {
        FabricEnergyStoragePlatform fabricEnergyStoragePlatform;
        class_1792 class_17922 = container.method_7909();
        if (class_17922 instanceof IEnergyStorageItem) {
            IEnergyStorageItem f = (IEnergyStorageItem)class_17922;
            fabricEnergyStoragePlatform = () -> SimpleItemEnergyStorageImpl.createSimpleStorage((ContainerItemContext)context, (long)f.getCapacity(), (long)(f.getTransport().canInsert() ? (long)f.getMaxReceive() : 0L), (long)(f.getTransport().canExtract() ? (long)f.getMaxConsume() : 0L));
        } else {
            fabricEnergyStoragePlatform = null;
        }
        return fabricEnergyStoragePlatform;
    }

    public static ICraftyEnergyStorage getItemCraftyEnergyStorageApi(class_1799 container) {
        SimpleItemCraftyStorage simpleItemCraftyStorage;
        class_1792 class_17922 = container.method_7909();
        if (class_17922 instanceof ICraftyStorageItem) {
            ICraftyStorageItem f = (ICraftyStorageItem)class_17922;
            simpleItemCraftyStorage = new SimpleItemCraftyStorage(container, 0, f.getCapacity(), f.getMaxConsume(), f.getMaxReceive(), f.getTransport(), f.getSupportedEnergyTier(), ItemContainerPlatform.isBlockItem(container));
        } else {
            simpleItemCraftyStorage = null;
        }
        return simpleItemCraftyStorage;
    }

    public static <T extends IPlatformHandler, U extends IModifiableTransportHandler & IPlatformHandler> U filteredOf(T handler, class_2350 direction, TransportState transportState, Function<T, U> sidedGetter) {
        filteredHandlersCache.entrySet().removeIf(e -> ((IPlatformHandler)e.getKey()).isRemoved());
        SideList list = filteredHandlersCache.computeIfAbsent(handler, d -> new SideList<IModifiableTransportHandler>(() -> null));
        if (!list.contains(direction)) {
            list.put(direction, (IModifiableTransportHandler)sidedGetter.apply(handler));
        }
        list.get(direction).setTransport(transportState);
        return list.get(direction) != null ? (U)list.get(direction) : null;
    }

    public static IPlatformItemHandler filteredOf(IPlatformItemHandler itemHandler, class_2350 direction, int[] slots, TransportState transportState) {
        FactoryItemHandler.SidedWrapper storage = FactoryAPIPlatform.filteredOf(itemHandler, direction, transportState, FactoryItemHandler.SidedWrapper::new);
        if (storage != null) {
            storage.slots = slots;
        }
        return storage;
    }

    public static IPlatformFluidHandler filteredOf(IPlatformFluidHandler fluidHandler, class_2350 direction, TransportState transportState) {
        return FactoryAPIPlatform.filteredOf((FactoryFluidHandler)fluidHandler, direction, transportState, FactoryFluidHandler.SidedWrapper::new);
    }

    public static IPlatformEnergyStorage filteredOf(IPlatformEnergyStorage energyStorage, class_2350 direction, TransportState transportState) {
        return FactoryAPIPlatform.filteredOf((FactoryEnergyStorage)energyStorage, direction, transportState, FactoryEnergyStorage.SidedWrapper::new);
    }

    public static IFactoryStorage getPlatformFactoryStorage(final class_2586 be) {
        if (be instanceof IFactoryStorage) {
            IFactoryStorage st = (IFactoryStorage)be;
            return st;
        }
        platformStorageWrappersCache.entrySet().removeIf(e -> ((class_2586)e.getKey()).method_11015());
        return platformStorageWrappersCache.computeIfAbsent(be, be1 -> new IFactoryStorage(){

            @Override
            public <T extends IPlatformHandler> ArbitrarySupplier<T> getStorage(FactoryStorage<T> storage, class_2350 direction) {
                ICraftyEnergyStorage energyStorage;
                if (storage == FactoryStorage.ITEM) {
                    Storage variantStorage = (Storage)ItemStorage.SIDED.find(be.method_10997(), be.method_11016(), be.method_11010(), be, (Object)direction);
                    if (variantStorage != null) {
                        return () -> () -> variantStorage;
                    }
                } else if (storage == FactoryStorage.FLUID) {
                    Storage variantStorage = (Storage)FluidStorage.SIDED.find(be.method_10997(), be.method_11016(), be.method_11010(), be, (Object)direction);
                    if (variantStorage instanceof IPlatformFluidHandler) {
                        return () -> (IPlatformHandler)variantStorage;
                    }
                    if (variantStorage != null) {
                        return () -> () -> variantStorage;
                    }
                } else if (storage == FactoryStorage.ENERGY) {
                    EnergyStorage energyStorage2 = (EnergyStorage)EnergyStorage.SIDED.find(be.method_10997(), be.method_11016(), be.method_11010(), be, (Object)direction);
                    if (energyStorage2 instanceof IPlatformEnergyStorage) {
                        return () -> (IPlatformHandler)energyStorage2;
                    }
                    if (energyStorage2 != null) {
                        return () -> () -> energyStorage2;
                    }
                } else if (storage == FactoryStorage.CRAFTY_ENERGY && (energyStorage = (ICraftyEnergyStorage)CraftyEnergyStorage.SIDED.find(be.method_10997(), be.method_11016(), be.method_11010(), be, (Object)direction)) != null) {
                    return () -> energyStorage;
                }
                return ArbitrarySupplier.empty();
            }
        });
    }

    public static boolean isClient() {
        return FactoryAPI.isClient();
    }

    public static <A extends ArgumentType<?>, T extends class_2314.class_7217<A>, I extends class_2314<A, T>> void registerByClassArgumentType(Class<A> infoClass, I argumentTypeInfo) {
        ArgumentTypesAccessor.fabric_getClassMap().put(infoClass, argumentTypeInfo);
    }

    public static <T> RegisterListing<T> createRegister(final String namespace, final class_2378<T> registry) {
        return new RegisterListing<T>(){
            private final List<RegisterListing.Holder<T>> REGISTER_LIST = new ArrayList();

            @Override
            public Collection<RegisterListing.Holder<T>> getEntries() {
                return this.REGISTER_LIST;
            }

            @Override
            public class_2378<T> getRegistry() {
                return registry;
            }

            @Override
            public String getNamespace() {
                return namespace;
            }

            @Override
            public void register() {
                this.forEach(o -> class_2378.method_10230((class_2378)registry, (class_2960)o.getId(), o.get()));
            }

            @Override
            public <V extends T> RegisterListing.Holder<V> add(String name, final Function<class_2960, V> supplier) {
                final class_2960 id = FactoryAPI.createLocation(this.getNamespace(), name);
                RegisterListing.Holder h = new RegisterListing.Holder<V>(){
                    V obj;

                    @Override
                    public class_2960 getId() {
                        return id;
                    }

                    @Override
                    public V get() {
                        return this.obj == null ? (this.obj = supplier.apply(this.getId())) : this.obj;
                    }
                };
                this.REGISTER_LIST.add(h);
                return h;
            }

            @Override
            @NotNull
            public Iterator<RegisterListing.Holder<T>> iterator() {
                return this.REGISTER_LIST.iterator();
            }

            @Override
            public Stream<RegisterListing.Holder<T>> stream() {
                return this.REGISTER_LIST.stream();
            }
        };
    }

    public static String getCurrentClassName(String className) {
        return FabricLoader.getInstance().getMappingResolver().mapClassName("official", className);
    }

    public static Stream<ModInfo> getVisibleModsStream() {
        return FactoryAPIPlatform.getMods().stream().filter(info -> !info.isHidden());
    }

    public static Collection<ModInfo> getMods() {
        FabricLoader.getInstance().getAllMods().forEach(m -> FactoryAPIPlatform.getModInfo(m.getMetadata().getId()));
        return MOD_INFOS.values();
    }

    public static ModInfo getModInfo(final String modId) {
        return FactoryAPI.isModLoaded(modId) ? MOD_INFOS.computeIfAbsent(modId, s -> new ModInfo(){
            Optional<ModContainer> opt;
            {
                this.opt = FabricLoader.getInstance().getModContainer(modId);
            }

            @Override
            public Collection<String> getAuthors() {
                return this.opt.map(c -> c.getMetadata().getAuthors().stream().map(Person::getName).toList()).orElse(Collections.emptyList());
            }

            @Override
            public Optional<String> getHomepage() {
                return this.opt.flatMap(c -> c.getMetadata().getContact().get("homepage"));
            }

            @Override
            public Optional<String> getIssues() {
                return this.opt.flatMap(c -> c.getMetadata().getContact().get("issues"));
            }

            @Override
            public Optional<String> getSources() {
                return this.opt.flatMap(c -> c.getMetadata().getContact().get("sources"));
            }

            @Override
            public Collection<String> getCredits() {
                return this.opt.map(c -> c.getMetadata().getContributors().stream().map(Person::getName).toList()).orElse(Collections.emptyList());
            }

            @Override
            public Collection<String> getLicense() {
                return this.opt.map(c -> c.getMetadata().getLicense()).orElse(Collections.emptyList());
            }

            @Override
            public String getDescription() {
                return this.opt.map(c -> c.getMetadata().getDescription()).orElse("");
            }

            @Override
            public Optional<String> getLogoFile(int i) {
                return this.opt.flatMap(c -> c.getMetadata().getIconPath(i));
            }

            @Override
            public Optional<Path> findResource(String s) {
                return this.opt.flatMap(c -> c.findPath(s));
            }

            @Override
            public String getId() {
                return modId;
            }

            @Override
            public String getVersion() {
                return this.opt.map(c -> c.getMetadata().getVersion().getFriendlyString()).orElse("");
            }

            @Override
            public String getName() {
                return this.opt.map(c -> c.getMetadata().getName()).orElse("");
            }

            @Override
            public boolean isHidden() {
                return this.opt.isPresent() && this.opt.get().getMetadata().containsCustomValue("fabric-api:module-lifecycle");
            }
        }) : null;
    }

    public static boolean isPackHidden(class_3288 pack) {
        return false;
    }

    @FunctionalInterface
    public static interface BlockEntitySupplier<T extends class_2586> {
        public T create(class_2338 var1, class_2680 var2);
    }
}

