/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import com.mojang.serialization.Codec;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_5250;

public enum FactoryCapacityTier implements class_3542
{
    BURNED("burned", class_124.field_1079, 0.0, 0, 0),
    BASIC("basic", class_124.field_1080, 0.2, 800, 1),
    ADVANCED("advanced", class_124.field_1061, 0.6, 2000, 3),
    HIGH("high", class_124.field_1078, 0.5, 4000, 8),
    ULTIMATE("ultimate", class_124.field_1064, 0.63, 6000, 12),
    QUANTUM("quantum", class_124.field_1062, 0.8, 10000, 16),
    CREATIVE("creative", class_124.field_1076, 1.0, Integer.MAX_VALUE, Integer.MAX_VALUE);

    public static final Codec<FactoryCapacityTier> CODEC;
    public final class_124 formatting;
    private final double conductivity;
    public final int initialCapacity;
    public final int capacityMultiplier;
    private final String name;
    public final class_2561 localizedName;

    private FactoryCapacityTier(String name, class_124 formatting, double j, int initialCapacity, int multiplier) {
        this(name, (class_2561)class_2561.method_43471((String)("tier.factory_api" + name)), formatting, j, initialCapacity, multiplier);
    }

    private FactoryCapacityTier(String name, class_2561 displayName, class_124 formatting, double j, int initialCapacity, int multiplier) {
        this.name = name;
        this.localizedName = displayName;
        this.formatting = formatting;
        this.conductivity = j;
        this.initialCapacity = initialCapacity;
        this.capacityMultiplier = multiplier;
    }

    public class_5250 getEnergyTierComponent(boolean isStored) {
        return this.getPrefixComponent("energy", isStored).method_27692(class_124.field_1075).method_10852(this.localizedName);
    }

    public class_5250 getOutputTierComponent() {
        return this.getPrefixComponent("energy", class_2561.method_43471((String)"tier.factory_api.output")).method_27692(class_124.field_1075).method_10852(this.localizedName);
    }

    public class_5250 getTierComponent(boolean isStored) {
        return this.getPrefixComponent("capacity", isStored).method_27692(class_124.field_1080).method_10852(this.localizedName);
    }

    public class_5250 getPrefixComponent(String keyType, boolean isStored) {
        if (isStored) {
            return this.getPrefixComponent(keyType, class_2561.method_43471((String)"tier.factory_api.stored"));
        }
        return this.getPrefixComponent(keyType, "");
    }

    public class_5250 getPrefixComponent(String keyType, Object ... objects) {
        return class_2561.method_43469((String)"tier.factory_api.display", (Object[])new Object[]{class_2561.method_43469((String)("tier.factory_api." + keyType), (Object[])objects)});
    }

    public boolean supportTier(FactoryCapacityTier tier) {
        return this.ordinal() >= tier.ordinal();
    }

    public double getConductivity() {
        return this.conductivity;
    }

    public double getPowFactor() {
        return Math.pow(this.conductivity, 2.0);
    }

    public boolean isBurned() {
        return this == BURNED;
    }

    public int getDefaultCapacity() {
        return this.initialCapacity * 10;
    }

    public int getStorageCapacity() {
        return this.getDefaultCapacity() * this.capacityMultiplier;
    }

    public FactoryCapacityTier increase(int ordinal) {
        return FactoryCapacityTier.values()[Math.min(FactoryCapacityTier.values().length - 1, this.ordinal() + ordinal)];
    }

    public int convertEnergyTo(int energy, FactoryCapacityTier tier) {
        return (int)Math.round(Math.max((double)energy + (this.getConductivity() - tier.getConductivity()) * (double)energy * (double)this.initialCapacity / (double)tier.initialCapacity, 0.0));
    }

    public String method_15434() {
        return this.name;
    }

    static {
        CODEC = class_3542.method_28140(FactoryCapacityTier::values);
    }
}

