/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.ConfigScreenHandler;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforgespi.language.IModInfo;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.base.FactoryExtraMenuSupplier;
import wily.factoryapi.base.client.FactoryOptions;
import wily.factoryapi.base.client.MinecraftAccessor;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.client.UIDefinitionManager;
import wily.factoryapi.base.client.screen.FactoryConfigScreen;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.base.network.HelloPayload;
import wily.factoryapi.base.network.OpenExtraMenuPayload;
import wily.factoryapi.base.network.SecureExecutor;
import wily.factoryapi.mixin.base.MenuScreensAccessor;
import wily.factoryapi.mixin.base.MenuTypeAccessor;
import wily.factoryapi.util.DynamicUtil;
import wily.factoryapi.util.FactoryGuiElement;
import wily.factoryapi.util.FluidInstance;
import wily.factoryapi.util.ModInfo;

public class FactoryAPIClient {
    public static final ResourceLocation BLOCK_ATLAS = FactoryAPI.createVanillaLocation("textures/atlas/blocks.png");
    public static final ResourceLocation BLOCK_ATLAS_ID = FactoryAPI.createVanillaLocation("blocks");
    public static final SecureExecutor SECURE_EXECUTOR = new SecureExecutor(){

        @Override
        public boolean isSecure() {
            return Minecraft.getInstance().player != null;
        }
    };
    private static final Map<String, Function<Screen, Screen>> defaultConfigScreens = new HashMap<String, Function<Screen, Screen>>();
    public static UIDefinitionManager uiDefinitionManager;
    public static final Map<ResourceLocation, ExtraModelId> extraModels;
    private static final Set<String> playerMods;
    public static final FactoryEvent<Consumer<Minecraft>> STOPPING;
    public static final FactoryEvent<Consumer<Minecraft>> RESIZE_DISPLAY;

    public static BakedModel getExtraModel(ResourceLocation resourceLocation) {
        return Minecraft.getInstance().getModelManager().getModel(extraModels.get(resourceLocation).modelId());
    }

    public static boolean hasAPIOnServer() {
        return FactoryAPIClient.hasModOnServer("factory_api");
    }

    public static boolean hasModOnServer(String id) {
        return playerMods.contains(id);
    }

    public static boolean hasLevel() {
        return Minecraft.getInstance().level != null;
    }

    public static RegistryAccess getRegistryAccess() {
        return Minecraft.getInstance().level.registryAccess();
    }

    public static ProfilerFiller getProfiler() {
        return Minecraft.getInstance().getProfiler();
    }

    public static ToastComponent getToasts() {
        return Minecraft.getInstance().getToasts();
    }

    public static float getPartialTick() {
        return Minecraft.getInstance().getDeltaFrameTime();
    }

    public static float getGamePartialTick(boolean allowFrozen) {
        return Minecraft.getInstance().isPaused() ? MinecraftAccessor.getInstance().getPausePartialTick() : (Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally() || !allowFrozen ? Minecraft.getInstance().getFrameTime() : 1.0f);
    }

    public static RecipeManager getRecipeManager() {
        return Minecraft.getInstance().level.getRecipeManager();
    }

    public static Level getLevel() {
        return Minecraft.getInstance().level;
    }

    public static long getWindow() {
        return Minecraft.getInstance().getWindow().getWindow();
    }

    public static void init() {
        FactoryAPIClient.registerConfigScreen(FactoryAPIPlatform.getModInfo("factory_api"), FactoryConfigScreen::createFactoryAPIConfigScreen);
        uiDefinitionManager = new UIDefinitionManager();
        FactoryEvent.registerReloadListener(PackType.CLIENT_RESOURCES, (PreparableReloadListener)uiDefinitionManager);
        FactoryAPIClient.setup(m -> FactoryOptions.CLIENT_STORAGE.load());
        FactoryAPIClient.preTick(m -> SECURE_EXECUTOR.executeAll());
        FactoryGuiElement.HOTBAR.post().register(graphics -> UIAccessor.of(Minecraft.getInstance().gui).getChildrenRenderables().forEach(r -> r.render(graphics, 0, 0, FactoryAPIClient.getPartialTick())));
        PlayerEvent.JOIN_EVENT.register(l -> {
            DynamicUtil.REGISTRY_OPS_CACHE.invalidateAll();
            DynamicUtil.DYNAMIC_ITEMS_CACHE.asMap().keySet().forEach(arg_0 -> DynamicUtil.DYNAMIC_ITEMS_CACHE.refresh(arg_0));
        });
        PlayerEvent.DISCONNECTED_EVENT.register(l -> {
            DynamicUtil.REGISTRY_OPS_CACHE.invalidateAll();
            DynamicUtil.DYNAMIC_ITEMS_CACHE.asMap().keySet().forEach(arg_0 -> DynamicUtil.DYNAMIC_ITEMS_CACHE.refresh(arg_0));
            if (FactoryAPIClient.hasAPIOnServer()) {
                FactoryConfig.COMMON_STORAGES.values().forEach(c -> {
                    if (c.isServerOnly()) {
                        c.reset();
                    } else if (c.allowSync()) {
                        c.load();
                    }
                });
            }
            playerMods.clear();
        });
    }

    public static void registerReloadListener(PreparableReloadListener reloadListener) {
        ((ReloadableResourceManager)Minecraft.getInstance().getResourceManager()).registerReloadListener(reloadListener);
    }

    public static <T extends AbstractContainerMenu> void handleExtraMenu(SecureExecutor executor, Player player, MenuType<T> menuType, OpenExtraMenuPayload payload) {
        AbstractContainerMenu menu;
        Object object;
        MenuType.MenuSupplier<?> menuSupplier = ((MenuTypeAccessor)menuType).getConstructor();
        if (menuSupplier instanceof FactoryExtraMenuSupplier) {
            FactoryExtraMenuSupplier supplier = (FactoryExtraMenuSupplier)menuSupplier;
            object = supplier.create(payload.menuId(), player.getInventory(), payload.extra());
        } else {
            object = menuType.create(payload.menuId(), player.getInventory());
        }
        player.containerMenu = menu = object;
        executor.execute(() -> Minecraft.getInstance().setScreen(MenuScreensAccessor.getConstructor(menuType).create(menu, player.getInventory(), payload.component())));
    }

    public static void setup(Consumer<Minecraft> listener) {
        FactoryAPIPlatform.getModEventBus().addListener(EventPriority.NORMAL, false, FMLClientSetupEvent.class, e -> listener.accept(Minecraft.getInstance()));
    }

    public static void preTick(Consumer<Minecraft> listener) {
        NeoForge.EVENT_BUS.addListener(TickEvent.ClientTickEvent.class, e -> {
            if (e.phase == TickEvent.Phase.START) {
                listener.accept(Minecraft.getInstance());
            }
        });
    }

    public static void postTick(Consumer<Minecraft> listener) {
        NeoForge.EVENT_BUS.addListener(TickEvent.ClientTickEvent.class, e -> {
            if (e.phase == TickEvent.Phase.END) {
                listener.accept(Minecraft.getInstance());
            }
        });
    }

    public static TextureAtlasSprite getFluidStillTexture(Fluid fluid) {
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(BLOCK_ATLAS).apply(IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture());
    }

    public static TextureAtlasSprite getFluidFlowingTexture(Fluid fluid) {
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(BLOCK_ATLAS).apply(IClientFluidTypeExtensions.of((Fluid)fluid).getFlowingTexture());
    }

    public static int getFluidColor(Fluid fluid, BlockAndTintGetter view, BlockPos pos) {
        return IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluid.defaultFluidState(), view, pos);
    }

    public static int getFluidColor(FluidInstance fluid) {
        return IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getTintColor(fluid.toStack());
    }

    public static void registerKeyMapping(Consumer<Consumer<KeyMapping>> registry) {
        FactoryAPIPlatform.getModEventBus().addListener(EventPriority.NORMAL, false, RegisterKeyMappingsEvent.class, e -> registry.accept(arg_0 -> ((RegisterKeyMappingsEvent)e).register(arg_0)));
    }

    public static Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    public static Screen getConfigScreen(ModInfo mod, Screen screen) {
        if (defaultConfigScreens.containsKey(mod.getId())) {
            return defaultConfigScreens.get(mod.getId()).apply(screen);
        }
        return ModList.get().getModContainerById(mod.getId()).flatMap(c -> ConfigScreenHandler.getScreenFactoryFor((IModInfo)c.getModInfo())).map(s -> (Screen)s.apply(Minecraft.getInstance(), screen)).orElse(null);
    }

    public static void registerDefaultConfigScreen(String modId, Function<Screen, Screen> configScreenFactory) {
        defaultConfigScreens.put(modId, configScreenFactory);
    }

    public static void registerConfigScreen(ModInfo mod, Function<Screen, Screen> configScreenFactory) {
        FactoryAPIClient.registerDefaultConfigScreen(mod.getId(), configScreenFactory);
        ModList.get().getModContainerById(mod.getId()).ifPresent(c -> c.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((m, s) -> (Screen)configScreenFactory.apply((Screen)s))));
    }

    public static void registerMenuScreen(Consumer<MenuScreenRegister> registry) {
        FactoryAPIPlatform.getModEventBus().addListener(RegisterMenuScreensEvent.class, e -> registry.accept((arg_0, arg_1) -> ((RegisterMenuScreensEvent)e).register(arg_0, arg_1)));
    }

    public static void registerBlockColor(Consumer<BiConsumer<BlockColor, Block>> registry) {
        FactoryAPIPlatform.getModEventBus().addListener(EventPriority.NORMAL, false, RegisterColorHandlersEvent.Block.class, e -> registry.accept((x$0, xva$1) -> e.register(x$0, new Block[]{xva$1})));
    }

    public static void registerItemColor(Consumer<BiConsumer<ItemColor, Item>> registry) {
        FactoryAPIPlatform.getModEventBus().addListener(EventPriority.NORMAL, false, RegisterColorHandlersEvent.Item.class, e -> registry.accept((x$0, xva$1) -> e.register(x$0, new ItemLike[]{xva$1})));
    }

    public static void registerRenderType(RenderType renderType, Block ... blocks) {
        for (Block block : blocks) {
            ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderType);
        }
    }

    public static void registerRenderType(RenderType renderType, Fluid ... fluids) {
        for (Fluid fluid : fluids) {
            ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)renderType);
        }
    }

    public static void registerExtraModels(Consumer<Consumer<ResourceLocation>> registry) {
        registry.accept(id -> extraModels.put((ResourceLocation)id, ExtraModelId.create(id)));
    }

    public static <T extends Entity> void registerEntityRenderer(Supplier<? extends EntityType<? extends T>> type, EntityRendererProvider<T> provider) {
        FactoryAPIPlatform.getModEventBus().addListener(EventPriority.NORMAL, false, EntityRenderersEvent.RegisterRenderers.class, e -> e.registerEntityRenderer((EntityType)type.get(), provider));
    }

    public static void registerLayerDefinition(ModelLayerLocation location, Supplier<LayerDefinition> definition) {
        FactoryAPIPlatform.getModEventBus().addListener(EventPriority.NORMAL, false, EntityRenderersEvent.RegisterLayerDefinitions.class, e -> e.registerLayerDefinition(location, definition));
    }

    public static void registerRenderLayer(Consumer<FactoryRenderLayerRegistry> registry) {
        FactoryAPIPlatform.getModEventBus().addListener(EventPriority.NORMAL, false, EntityRenderersEvent.AddLayers.class, e -> registry.accept(new FactoryRenderLayerRegistry((EntityRenderersEvent.AddLayers)e){
            final /* synthetic */ EntityRenderersEvent.AddLayers val$e;
            {
                this.val$e = addLayers;
            }

            @Override
            public EntityRenderer<?> getEntityRenderer(EntityType<? extends LivingEntity> entityType) {
                return this.val$e.getRenderer(entityType);
            }

            @Override
            public EntityModelSet getEntityModelSet() {
                return this.val$e.getEntityModels();
            }

            @Override
            public <T extends LivingEntity, M extends EntityModel<T>> void register(LivingEntityRenderer<T, M> renderer, RenderLayer<T, M> renderLayer) {
                renderer.addLayer(renderLayer);
            }
        }));
    }

    public static void handleHelloPayload(HelloPayload payload) {
        playerMods.addAll(payload.modIds());
    }

    static {
        extraModels = new HashMap<ResourceLocation, ExtraModelId>();
        playerMods = new HashSet<String>();
        STOPPING = new FactoryEvent<Consumer>(e -> m -> e.invokeAll(l -> l.accept(m)));
        RESIZE_DISPLAY = new FactoryEvent<Consumer>(e -> m -> e.invokeAll(l -> l.accept(m)));
    }

    public record ExtraModelId(StateDefinition<Block, BlockState> stateDefinition, BlockState blockState, ResourceLocation id, ModelResourceLocation modelId) {
        public static ExtraModelId create(ResourceLocation id) {
            StateDefinition stateDefinition = new StateDefinition.Builder((Object)Blocks.AIR).create(Block::defaultBlockState, BlockState::new);
            return new ExtraModelId((StateDefinition<Block, BlockState>)stateDefinition, (BlockState)stateDefinition.any(), id, BlockModelShaper.stateToModelLocation((ResourceLocation)id, (BlockState)((BlockState)stateDefinition.any())));
        }
    }

    public static interface PlayerEvent
    extends Consumer<LocalPlayer> {
        public static final FactoryEvent<PlayerEvent> JOIN_EVENT = new FactoryEvent<PlayerEvent>(e -> s -> e.invokeAll(t -> t.accept(s)));
        public static final FactoryEvent<PlayerEvent> DISCONNECTED_EVENT = new FactoryEvent<PlayerEvent>(e -> s -> e.invokeAll(t -> t.accept(s)));
    }

    public static interface MenuScreenRegister {
        public <H extends AbstractContainerMenu, S extends Screen> void register(MenuType<? extends H> var1, MenuScreens.ScreenConstructor<H, S> var2);
    }

    public static interface FactoryRenderLayerRegistry {
        public EntityRenderer<?> getEntityRenderer(EntityType<? extends LivingEntity> var1);

        public EntityModelSet getEntityModelSet();

        public <T extends LivingEntity, M extends EntityModel<T>> void register(LivingEntityRenderer<T, M> var1, RenderLayer<T, M> var2);
    }
}

