/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi;

import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.players.PlayerList;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import org.apache.logging.log4j.util.TriConsumer;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.network.CommonNetwork;

public class FactoryEvent<T> {
    protected final List<T> listeners = new ArrayList<T>();
    public final T invoker;

    public FactoryEvent(Function<FactoryEvent<T>, T> invoker) {
        this.invoker = invoker.apply(this);
    }

    public void invokeAll(Consumer<T> invoker) {
        this.listeners.forEach(invoker);
    }

    public void invokeAnyMatch(Predicate<T> invoker) {
        for (T listener : this.listeners) {
            if (!invoker.test(listener)) continue;
            return;
        }
    }

    public void register(T listener) {
        this.listeners.add(listener);
    }

    public static void setup(Runnable run) {
        FactoryAPIPlatform.getModEventBus().addListener(EventPriority.NORMAL, false, FMLCommonSetupEvent.class, e -> run.run());
    }

    public static void tagsLoaded(Runnable run) {
        FactoryAPIPlatform.getForgeEventBus().addListener(EventPriority.NORMAL, false, TagsUpdatedEvent.class, e -> run.run());
    }

    public static void serverStarted(Consumer<MinecraftServer> apply) {
        FactoryAPIPlatform.getForgeEventBus().addListener(EventPriority.NORMAL, false, ServerStartedEvent.class, e -> apply.accept(e.getServer()));
    }

    public static void serverStopping(Consumer<MinecraftServer> apply) {
        FactoryAPIPlatform.getForgeEventBus().addListener(EventPriority.NORMAL, false, ServerStoppingEvent.class, e -> apply.accept(e.getServer()));
    }

    public static void serverStopped(Consumer<MinecraftServer> apply) {
        FactoryAPIPlatform.getForgeEventBus().addListener(EventPriority.NORMAL, false, ServerStoppedEvent.class, e -> apply.accept(e.getServer()));
    }

    public static void preServerTick(Consumer<MinecraftServer> apply) {
        NeoForge.EVENT_BUS.addListener(TickEvent.ServerTickEvent.class, e -> {
            if (e.phase == TickEvent.Phase.START) {
                apply.accept(e.getServer());
            }
        });
    }

    public static void afterServerTick(Consumer<MinecraftServer> apply) {
        NeoForge.EVENT_BUS.addListener(TickEvent.ServerTickEvent.class, e -> {
            if (e.phase == TickEvent.Phase.END) {
                apply.accept(e.getServer());
            }
        });
    }

    public static void registerReloadListener(PackType type, PreparableReloadListener reloadListener) {
        if (type == PackType.CLIENT_RESOURCES) {
            FactoryAPIClient.registerReloadListener(reloadListener);
        } else {
            NeoForge.EVENT_BUS.addListener(AddReloadListenerEvent.class, e -> e.addListener(reloadListener));
        }
    }

    public static void registerCommands(TriConsumer<CommandDispatcher<CommandSourceStack>, CommandBuildContext, Commands.CommandSelection> register) {
        NeoForge.EVENT_BUS.addListener(RegisterCommandsEvent.class, e -> register.accept((Object)e.getDispatcher(), (Object)e.getBuildContext(), (Object)e.getCommandSelection()));
    }

    public static Pack createBuiltInPack(ResourceLocation name, Component displayName, boolean defaultEnabled, PackType type, Pack.Position position, Path resourcePath) {
        return Pack.readMetaAndCreate((String)name.toString(), (Component)displayName, (boolean)false, (Pack.ResourcesSupplier)new PathPackResources.PathResourcesSupplier(resourcePath, true), (PackType)type, (Pack.Position)position, (PackSource)PackSource.create(arg_0 -> ((PackSource)PackSource.BUILT_IN).decorate(arg_0), (boolean)defaultEnabled));
    }

    public static void registerBuiltInPacks(Consumer<PackRegistry> registry) {
        FactoryAPIPlatform.getModEventBus().addListener(EventPriority.NORMAL, false, AddPackFindersEvent.class, event -> registry.accept((path, name, displayName, position, defaultEnabled) -> {
            Path resourcePath = ModList.get().getModFileById(name.getNamespace()).getFile().findResource(new String[]{path});
            for (PackType type : PackType.values()) {
                if (event.getPackType() != type || !Files.isDirectory(resourcePath.resolve(type.getDirectory()), new LinkOption[0])) continue;
                Pack pack = FactoryEvent.createBuiltInPack(name, displayName, defaultEnabled, type, position, resourcePath);
                event.addRepositorySource(packConsumer -> packConsumer.accept(pack));
            }
        }));
    }

    public static void registerPayload(Consumer<PayloadRegistry> registry) {
        FactoryAPIPlatform.getModEventBus().addListener(RegisterPayloadHandlerEvent.class, e -> registry.accept(new PayloadRegistry((RegisterPayloadHandlerEvent)e){
            final /* synthetic */ RegisterPayloadHandlerEvent val$e;
            {
                this.val$e = registerPayloadHandlerEvent;
            }

            @Override
            public <T extends CommonNetwork.Payload> void register(boolean c2s, CommonNetwork.Identifier<T> id) {
                block3: {
                    IPayloadRegistrar registrar;
                    block2: {
                        registrar = this.val$e.registrar(id.location().getNamespace()).optional();
                        if (c2s) break block2;
                        if (!FMLEnvironment.dist.isClient()) break block3;
                    }
                    registrar.play(id.location(), id::decode, (h, arg) -> h.applySided(arg.flow().isClientbound(), () -> arg.player().orElse(null)));
                }
            }
        }));
    }

    @FunctionalInterface
    public static interface PackRegistry {
        public void register(String var1, ResourceLocation var2, Component var3, Pack.Position var4, boolean var5);

        default public void register(String path, ResourceLocation name, boolean enabledByDefault) {
            this.register(path, name, (Component)Component.translatable((String)(name.getNamespace() + ".builtin." + name.getPath())), Pack.Position.TOP, enabledByDefault);
        }

        default public void registerResourcePack(ResourceLocation location, boolean enabledByDefault) {
            this.register("resourcepacks/" + location.getPath(), location, enabledByDefault);
        }

        default public void registerResourcePack(String pathName, boolean enabledByDefault) {
            this.registerResourcePack(FactoryAPI.createVanillaLocation(pathName), enabledByDefault);
        }
    }

    public static interface PayloadRegistry {
        public <T extends CommonNetwork.Payload> void register(boolean var1, CommonNetwork.Identifier<T> var2);
    }

    public static interface PlayerEvent
    extends Consumer<ServerPlayer> {
        public static final FactoryEvent<Consumer<PlayerList>> RELOAD_RESOURCES_EVENT = new FactoryEvent<Consumer>(e -> s -> e.invokeAll(t -> t.accept(s)));
        public static final FactoryEvent<PlayerEvent> JOIN_EVENT = new FactoryEvent<PlayerEvent>(e -> s -> e.invokeAll(t -> t.accept(s)));
        public static final FactoryEvent<PlayerEvent> REMOVED_EVENT = new FactoryEvent<PlayerEvent>(e -> s -> e.invokeAll(t -> t.accept(s)));
    }

    public static interface ServerSave {
        public static final FactoryEvent<ServerSave> EVENT = new FactoryEvent<ServerSave>(e -> (server, log, flush, force) -> e.invokeAll(t -> t.run(server, log, flush, force)));

        public void run(MinecraftServer var1, boolean var2, boolean var3, boolean var4);
    }
}

