/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.base.FactoryItemSlot;
import wily.factoryapi.base.IFactoryExpandedStorage;
import wily.factoryapi.base.IModifiableTransportHandler;
import wily.factoryapi.base.IPlatformItemHandler;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.util.FactoryItemUtil;

public class FactoryItemHandler
extends SimpleContainer
implements IPlatformItemHandler {
    protected BlockEntity be;
    protected TransportState transportState;

    public FactoryItemHandler(int inventorySize, BlockEntity be, TransportState transportState) {
        super(inventorySize);
        this.be = be;
        this.transportState = transportState;
    }

    public boolean canTakeItem(Container container, int i, ItemStack itemStack) {
        return this.getTransport().canExtract();
    }

    public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
        IFactoryExpandedStorage storage;
        BlockEntity blockEntity;
        return this.getTransport().canInsert() && (!((blockEntity = this.be) instanceof IFactoryExpandedStorage) || ((FactoryItemSlot)(storage = (IFactoryExpandedStorage)blockEntity).getSlots(null).get(slot)).mayPlace(stack));
    }

    public FactoryItemHandler(IPlatformItemHandler handler, TransportState transportState) {
        BlockEntity blockEntity;
        int n = handler.getContainerSize();
        if (handler instanceof FactoryItemHandler) {
            FactoryItemHandler h = (FactoryItemHandler)handler;
            blockEntity = h.be;
        } else {
            blockEntity = null;
        }
        this(n, blockEntity, transportState);
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getItem(slot);
        if (!stackInSlot.isEmpty()) {
            if (stackInSlot.getCount() >= Math.min(stackInSlot.getMaxStackSize(), this.getMaxStackSize())) {
                return stack;
            }
            if (!FactoryItemUtil.equalItems(stack, stackInSlot)) {
                return stack;
            }
            if (!this.canPlaceItem(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.getMaxStackSize(), this.getMaxStackSize()) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    this.setItem(slot, copy);
                    this.setChanged();
                }
                return ItemStack.EMPTY;
            }
            stack = stack.copy();
            if (!simulate) {
                ItemStack copy = stack.split(m);
                copy.grow(stackInSlot.getCount());
                this.setItem(slot, copy);
                this.setChanged();
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!this.canPlaceItem(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.getMaxStackSize(), this.getMaxStackSize());
        if (m < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                this.setItem(slot, stack.split(m));
                this.setChanged();
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!simulate) {
            this.setItem(slot, stack);
            this.setChanged();
        }
        return ItemStack.EMPTY;
    }

    @Override
    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || !this.canTakeItem(this, slot, this.getItem(slot))) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getItem(slot);
        if (stackInSlot.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            if (stackInSlot.getCount() < amount) {
                return stackInSlot.copy();
            }
            ItemStack copy = stackInSlot.copy();
            copy.setCount(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.getCount(), amount);
        ItemStack decrStackSize = this.removeItem(slot, m);
        this.setChanged();
        return decrStackSize;
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (this.be != null) {
            this.be.setChanged();
        }
    }

    @Override
    public CompoundTag serializeTag() {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.getItem(i).isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            this.getItem(i).save(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Items", (Tag)nbtTagList);
        return nbt;
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        return this.be == null || Container.stillValidBlockEntity((BlockEntity)this.be, (Player)player);
    }

    @Override
    public void deserializeTag(CompoundTag tag) {
        ListTag tagList = tag.getList("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.getCompound(i);
            int slot = itemTags.getInt("Slot");
            if (slot < 0 || slot >= this.getContainerSize()) continue;
            this.setItem(slot, ItemStack.of((CompoundTag)itemTags));
        }
    }

    public ItemStack addItem(ItemStack itemStack) {
        return super.addItem(itemStack);
    }

    @Override
    public TransportState getTransport() {
        return this.transportState;
    }

    @Override
    public boolean isRemoved() {
        return this.be != null && this.be.isRemoved();
    }

    public static class SidedWrapper
    extends FactoryItemHandler
    implements IModifiableTransportHandler {
        private final IPlatformItemHandler platformItemHandler;
        public int[] slots = new int[0];

        public SidedWrapper(IPlatformItemHandler platformItemHandler) {
            super(platformItemHandler, platformItemHandler.getTransport());
            this.platformItemHandler = platformItemHandler;
        }

        @Override
        public boolean canPlaceItem(int i, @NotNull ItemStack arg) {
            return this.platformItemHandler.canPlaceItem(i, arg) && ArrayUtils.contains((int[])this.slots, (int)i);
        }

        @Override
        public boolean canTakeItem(Container container, int i, ItemStack itemStack) {
            return this.platformItemHandler.canTakeItem(container, i, itemStack) && ArrayUtils.contains((int[])this.slots, (int)i);
        }

        @Override
        public ItemStack getItem(int i) {
            return ArrayUtils.contains((int[])this.slots, (int)i) ? this.platformItemHandler.getItem(i) : ItemStack.EMPTY;
        }

        @Override
        public ItemStack removeItem(int i, int j) {
            return this.platformItemHandler.removeItem(i, j);
        }

        @Override
        public ItemStack removeItemNoUpdate(int i) {
            return this.platformItemHandler.removeItemNoUpdate(i);
        }

        public void setItem(int i, ItemStack arg) {
            this.platformItemHandler.setItem(i, arg);
        }

        @Override
        public void setTransport(TransportState state) {
            this.transportState = state;
        }
    }
}

