/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.event.furnace.FurnaceFuelBurnTimeEvent;
import wily.factoryapi.FactoryAPIPlatform;

public class FuelManager {
    public static int getBurnTime(Item item) {
        return FuelManager.getBurnTime(item.getDefaultInstance());
    }

    public static Map<Item, Integer> getMap() {
        return AbstractFurnaceBlockEntity.getFuel();
    }

    public static int getBurnTime(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        return stack.getBurnTime(null);
    }

    public static boolean isFuel(Item item) {
        return FuelManager.getBurnTime(item) > 0;
    }

    public static boolean isFuel(ItemStack stack) {
        return FuelManager.isFuel(stack.getItem());
    }

    public static void add(Item item, int burnTime) {
        FactoryAPIPlatform.getForgeEventBus().addListener(EventPriority.NORMAL, false, FurnaceFuelBurnTimeEvent.class, e -> {
            if (e.getItemStack().is(item)) {
                e.setBurnTime(burnTime);
            }
        });
    }
}

