/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.forge;

import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.IPlatformHandlerApi;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.util.FluidInstance;

public interface ForgeFluidHandlerPlatform
extends IPlatformFluidHandler,
IPlatformHandlerApi<IFluidHandler> {
    @Override
    default public SlotsIdentifier identifier() {
        return SlotsIdentifier.GENERIC;
    }

    @Override
    @NotNull
    default public FluidInstance getFluidInstance() {
        return FactoryAPIPlatform.fluidStackToInstance(((IFluidHandler)this.getHandler()).getFluidInTank(0));
    }

    @Override
    default public int getMaxFluid() {
        return ((IFluidHandler)this.getHandler()).getTankCapacity(0);
    }

    @Override
    default public boolean isFluidValid(@NotNull FluidInstance instance) {
        return ((IFluidHandler)this.getHandler()).isFluidValid(0, new FluidStack(instance.getFluid(), instance.getAmount()));
    }

    @Override
    default public int fill(FluidInstance resource, boolean simulate) {
        return ((IFluidHandler)this.getHandler()).fill(new FluidStack(resource.getFluid(), resource.getAmount()), FactoryAPIPlatform.fluidActionOf(simulate));
    }

    @Override
    @NotNull
    default public FluidInstance drain(FluidInstance resource, boolean simulate) {
        return FactoryAPIPlatform.fluidStackToInstance(((IFluidHandler)this.getHandler()).drain(new FluidStack(resource.getFluid(), resource.getAmount()), FactoryAPIPlatform.fluidActionOf(simulate)));
    }

    @Override
    @NotNull
    default public FluidInstance drain(int maxDrain, boolean simulate) {
        return this.drain(this.getFluidInstance().copyWithAmount(maxDrain), simulate);
    }

    @Override
    default public void setFluid(FluidInstance fluidStack) {
        if (!this.getFluidInstance().isEmpty()) {
            this.drain(this.getFluidInstance(), false);
        }
        this.fill(fluidStack, false);
    }

    @Override
    default public TransportState getTransport() {
        return TransportState.EXTRACT_INSERT;
    }

    @Override
    default public CompoundTag serializeTag() {
        return new CompoundTag();
    }

    @Override
    default public void deserializeTag(CompoundTag nbt) {
    }
}

