/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeUtil {
    private static final Vec3 fromOrigin = new Vec3(-0.5, -0.5, -0.5);

    public static AABB rotate(AABB box, Direction side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> box;
            case Direction.UP -> new AABB(box.minX, -box.minY, -box.minZ, box.maxX, -box.maxY, -box.maxZ);
            case Direction.NORTH -> new AABB(box.minX, -box.minZ, box.minY, box.maxX, -box.maxZ, box.maxY);
            case Direction.SOUTH -> new AABB(-box.minX, -box.minZ, -box.minY, -box.maxX, -box.maxZ, -box.maxY);
            case Direction.WEST -> new AABB(box.minY, -box.minZ, -box.minX, box.maxY, -box.maxZ, -box.maxX);
            case Direction.EAST -> new AABB(-box.minY, -box.minZ, box.minX, -box.maxY, -box.maxZ, box.maxX);
        };
    }

    public static AABB rotate(AABB box, Rotation rotation) {
        return switch (rotation) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> box;
            case Rotation.CLOCKWISE_90 -> new AABB(-box.minZ, box.minY, box.minX, -box.maxZ, box.maxY, box.maxX);
            case Rotation.CLOCKWISE_180 -> new AABB(-box.minX, box.minY, -box.minZ, -box.maxX, box.maxY, -box.maxZ);
            case Rotation.COUNTERCLOCKWISE_90 -> new AABB(box.minZ, box.minY, -box.minX, box.maxZ, box.maxY, -box.maxX);
        };
    }

    public static AABB rotateHorizontal(AABB box, Direction side) {
        return switch (side) {
            case Direction.NORTH -> VoxelShapeUtil.rotate(box, Rotation.NONE);
            case Direction.SOUTH -> VoxelShapeUtil.rotate(box, Rotation.CLOCKWISE_180);
            case Direction.WEST -> VoxelShapeUtil.rotate(box, Rotation.COUNTERCLOCKWISE_90);
            case Direction.EAST -> VoxelShapeUtil.rotate(box, Rotation.CLOCKWISE_90);
            default -> box;
        };
    }

    public static VoxelShape rotate(VoxelShape shape, Direction side) {
        return VoxelShapeUtil.rotate(shape, box -> VoxelShapeUtil.rotate(box, side));
    }

    public static VoxelShape rotate(VoxelShape shape, Rotation rotation) {
        return VoxelShapeUtil.rotate(shape, box -> VoxelShapeUtil.rotate(box, rotation));
    }

    public static VoxelShape rotateHorizontal(VoxelShape shape, Direction side) {
        return VoxelShapeUtil.rotate(shape, box -> VoxelShapeUtil.rotateHorizontal(box, side));
    }

    public static VoxelShape rotate(VoxelShape shape, UnaryOperator<AABB> rotateFunction) {
        ArrayList<VoxelShape> rotatedPieces = new ArrayList<VoxelShape>();
        List sourceBoundingBoxes = shape.toAabbs();
        for (AABB sourceBoundingBox : sourceBoundingBoxes) {
            rotatedPieces.add(Shapes.create((AABB)((AABB)rotateFunction.apply(sourceBoundingBox.move(VoxelShapeUtil.fromOrigin.x, VoxelShapeUtil.fromOrigin.y, VoxelShapeUtil.fromOrigin.z))).move(-VoxelShapeUtil.fromOrigin.x, -VoxelShapeUtil.fromOrigin.z, -VoxelShapeUtil.fromOrigin.z)));
        }
        return VoxelShapeUtil.combine(rotatedPieces);
    }

    public static VoxelShape combine(VoxelShape ... shapes) {
        return VoxelShapeUtil.batchCombine(Shapes.empty(), BooleanOp.OR, true, shapes);
    }

    public static VoxelShape combine(Collection<VoxelShape> shapes) {
        return VoxelShapeUtil.batchCombine(Shapes.empty(), BooleanOp.OR, true, shapes);
    }

    public static VoxelShape exclude(VoxelShape ... shapes) {
        return VoxelShapeUtil.batchCombine(Shapes.block(), BooleanOp.ONLY_FIRST, true, shapes);
    }

    public static VoxelShape batchCombine(VoxelShape initial, BooleanOp function, boolean simplify, Collection<VoxelShape> shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.joinUnoptimized((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)function);
        }
        return simplify ? combinedShape.optimize() : combinedShape;
    }

    public static VoxelShape batchCombine(VoxelShape initial, BooleanOp function, boolean simplify, VoxelShape ... shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.joinUnoptimized((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)function);
        }
        return simplify ? combinedShape.optimize() : combinedShape;
    }
}

