/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.BlockSide;
import wily.factoryapi.base.FactoryItemSlot;
import wily.factoryapi.base.FactoryStorage;
import wily.factoryapi.base.IFactoryStorage;
import wily.factoryapi.base.IHasIdentifier;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.SideList;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportSide;
import wily.factoryapi.util.CompoundTagUtil;

public interface IFactoryExpandedStorage
extends IFactoryStorage {
    default public void replaceSidedStorage(BlockSide blockSide, SideList<TransportSide> side, TransportSide replacement) {
        IFactoryExpandedStorage iFactoryExpandedStorage = this;
        if (iFactoryExpandedStorage instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)iFactoryExpandedStorage;
            side.put(blockSide.blockStateToFacing(be.getBlockState()), replacement);
        }
    }

    default public NonNullList<FactoryItemSlot> getSlots(@Nullable Player player) {
        return NonNullList.create();
    }

    default public List<IPlatformFluidHandler> getTanks() {
        return NonNullList.create();
    }

    default public Map<SlotsIdentifier, int[]> itemSlotsIdentifiers() {
        LinkedHashMap<SlotsIdentifier, int[]> map = new LinkedHashMap<SlotsIdentifier, int[]>();
        for (FactoryItemSlot slot : this.getSlots(null)) {
            int[] list = map.getOrDefault(slot.identifier(), new int[0]);
            if (ArrayUtils.contains((int[])list, (int)slot.getContainerSlot())) continue;
            list = ArrayUtils.add((int[])list, (int)slot.getContainerSlot());
            map.put(slot.identifier(), list);
        }
        return map;
    }

    default public List<Direction> getBlockedSides() {
        return Collections.emptyList();
    }

    default public List<SlotsIdentifier> getItemSlotsIdentifiers() {
        return List.copyOf(this.itemSlotsIdentifiers().keySet());
    }

    default public List<SlotsIdentifier> getFluidSlotsIdentifiers() {
        return IHasIdentifier.getSlotsIdentifiers(this.getTanks());
    }

    default public void loadTag(CompoundTag compoundTag) {
        this.getStorage(FactoryStorage.CRAFTY_ENERGY).ifPresent(e -> e.deserializeTag(CompoundTagUtil.getCompoundTagOrEmpty(compoundTag, "CYEnergy")));
        this.getStorage(FactoryStorage.ENERGY).ifPresent(e -> e.deserializeTag(CompoundTagUtil.getCompoundTagOrEmpty(compoundTag, "Energy")));
        if (!this.getTanks().isEmpty()) {
            this.getTanks().forEach(tank -> tank.deserializeTag(CompoundTagUtil.getCompoundTagOrEmpty(compoundTag, tank.getName())));
        }
        this.getStorage(FactoryStorage.ITEM).ifPresent(e -> e.deserializeTag((Tag)CompoundTagUtil.getCompoundTagOrEmpty(compoundTag, "inventory")));
        this.getStorageSides(FactoryStorage.FLUID).ifPresent(f -> TransportSide.deserializeTag(CompoundTagUtil.getCompoundTagOrEmpty(compoundTag, "fluidSides"), f, this.getTanks()));
        this.getStorageSides(FactoryStorage.ITEM).ifPresent(i -> TransportSide.deserializeTag(CompoundTagUtil.getCompoundTagOrEmpty(compoundTag, "itemSides"), i, this.getItemSlotsIdentifiers()));
        this.getStorageSides(FactoryStorage.CRAFTY_ENERGY).ifPresent(e -> TransportSide.deserializeTag(CompoundTagUtil.getCompoundTagOrEmpty(compoundTag, "energySides"), e));
    }

    default public void saveTag(CompoundTag compoundTag) {
        this.getStorage(FactoryStorage.CRAFTY_ENERGY).ifPresent(e -> compoundTag.put("CYEnergy", e.serializeTag()));
        this.getStorage(FactoryStorage.ENERGY).ifPresent(e -> compoundTag.put("Energy", e.serializeTag()));
        if (!this.getTanks().isEmpty()) {
            this.getTanks().forEach(tank -> compoundTag.put(tank.getName(), (Tag)tank.serializeTag()));
        }
        this.getStorage(FactoryStorage.ITEM).ifPresent(i -> compoundTag.put("inventory", i.serializeTag()));
        this.getStorageSides(FactoryStorage.FLUID).ifPresent(f -> compoundTag.put("fluidSides", (Tag)TransportSide.serializeTag(f, this.getTanks())));
        this.getStorageSides(FactoryStorage.ITEM).ifPresent(i -> compoundTag.put("itemSides", (Tag)TransportSide.serializeTag(i, this.getItemSlotsIdentifiers())));
        this.getStorageSides(FactoryStorage.CRAFTY_ENERGY).ifPresent(e -> compoundTag.put("energySides", (Tag)TransportSide.serializeTag(e)));
    }
}

