/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.mixin.base;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.gui.RealmsDataFetcher;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ProfileKeyPairManager;
import net.minecraft.client.multiplayer.chat.report.ReportEnvironment;
import net.minecraft.client.multiplayer.chat.report.ReportingContext;
import net.minecraft.client.resources.SplashManager;
import net.minecraft.client.telemetry.ClientTelemetryManager;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.client.MinecraftAccessor;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.mixin.base.RealmsAvailabilityAccessor;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin
implements MinecraftAccessor {
    @Shadow
    @Nullable
    public ClientLevel level;
    @Shadow
    @Final
    public Gui gui;
    @Mutable
    @Shadow
    @Final
    private User user;
    @Mutable
    @Shadow
    @Final
    private ProfileKeyPairManager profileKeyPairManager;
    @Mutable
    @Shadow
    @Final
    private UserApiService userApiService;
    @Mutable
    @Shadow
    @Final
    private CompletableFuture<ProfileResult> profileFuture;
    @Mutable
    @Shadow
    @Final
    private CompletableFuture<UserApiService.UserProperties> userPropertiesFuture;
    @Shadow
    @Final
    private YggdrasilAuthenticationService authenticationService;
    @Mutable
    @Shadow
    @Final
    private ClientTelemetryManager telemetryManager;
    @Shadow
    @Final
    private static Logger LOGGER;
    @Shadow
    private ReportingContext reportingContext;
    @Mutable
    @Shadow
    @Final
    private RealmsDataFetcher realmsDataFetcher;
    @Shadow
    @Final
    private SplashManager splashManager;

    @Inject(method={"resizeDisplay"}, at={@At(value="RETURN")})
    public void resizeDisplay(CallbackInfo ci) {
        if (this.level != null) {
            UIAccessor.of(this.gui).reloadUI();
            ((Consumer)FactoryAPIClient.RESIZE_DISPLAY.invoker).accept(Minecraft.getInstance());
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="RETURN")})
    public void setScreen(Screen screen, CallbackInfo ci) {
        if (this.level != null) {
            UIAccessor.of(this.gui).reloadUI();
        }
    }

    @Inject(method={"stop"}, at={@At(value="RETURN")})
    public void stop(CallbackInfo ci) {
        ((Consumer)FactoryAPIClient.STOPPING.invoker).accept(Minecraft.getInstance());
    }

    @Override
    public boolean hasGameLoaded() {
        return Minecraft.getInstance().isGameLoadFinished();
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;wrapScreenError(Ljava/lang/Runnable;Ljava/lang/String;Ljava/lang/String;)V")})
    public void beforeScreenTick(CallbackInfo ci) {
        if (Minecraft.getInstance().screen == null) {
            return;
        }
        UIAccessor accessor = UIAccessor.of(Minecraft.getInstance().screen);
        Screen.wrapScreenError(accessor::beforeTick, (String)"Ticking screen before tick", (String)Minecraft.getInstance().screen.getClass().getCanonicalName());
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;wrapScreenError(Ljava/lang/Runnable;Ljava/lang/String;Ljava/lang/String;)V", shift=At.Shift.AFTER)})
    public void afterScreenTick(CallbackInfo ci) {
        if (Minecraft.getInstance().screen == null) {
            return;
        }
        UIAccessor accessor = UIAccessor.of(Minecraft.getInstance().screen);
        Screen.wrapScreenError(accessor::afterTick, (String)"Ticking screen after tick", (String)Minecraft.getInstance().screen.getClass().getCanonicalName());
    }

    @Override
    public boolean setUser(User user) {
        if (user == null) {
            LOGGER.warn("Something went wrong, the User cannot be set to null");
            return false;
        }
        this.user = this.splashManager.user = user;
        this.profileFuture = CompletableFuture.supplyAsync(() -> Minecraft.getInstance().getMinecraftSessionService().fetchProfile(user.getProfileId(), true), Util.nonCriticalIoPool());
        this.userApiService = user.getType() != User.Type.MSA ? UserApiService.OFFLINE : this.authenticationService.createUserApiService(user.getAccessToken());
        this.userPropertiesFuture = CompletableFuture.supplyAsync(() -> {
            try {
                return this.userApiService.fetchProperties();
            }
            catch (AuthenticationException var2) {
                LOGGER.error("Failed to fetch user properties", (Throwable)var2);
                return UserApiService.OFFLINE_PROPERTIES;
            }
        }, Util.nonCriticalIoPool());
        this.profileKeyPairManager = ProfileKeyPairManager.create((UserApiService)this.userApiService, (User)user, (Path)Minecraft.getInstance().gameDirectory.toPath());
        this.telemetryManager = new ClientTelemetryManager(Minecraft.getInstance(), this.userApiService, user);
        this.reportingContext = ReportingContext.create((ReportEnvironment)ReportEnvironment.local(), (UserApiService)this.userApiService);
        this.realmsDataFetcher = new RealmsDataFetcher(RealmsClient.create((Minecraft)Minecraft.getInstance()));
        RealmsAvailabilityAccessor.setFuture(null);
        return true;
    }
}

