/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.config.FactoryCommonOptions;
import wily.factoryapi.util.VariableResolver;

public record BooleanExpressionEvaluator(String expression, List<Token> tokens, Stack<Boolean> values, Stack<Operator> operators) {
    public static final LoadingCache<String, BooleanExpressionEvaluator> EXPRESSION_CACHE = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(15L)).build(CacheLoader.from(BooleanExpressionEvaluator::create));
    private static final Pattern TOKEN_PATTERN = Pattern.compile("(\\$\\{[\\dA-Za-z_.-]+})|(:?(?:false|true))|(:?\\d+\\.?\\d*)|(!|&&|&|\\|\\||\\|)|(==|!=|>=|<=|>|<)");

    public BooleanExpressionEvaluator(String expression, List<Token> tokens) {
        this(expression, tokens, new Stack<Boolean>(), new Stack<Operator>());
    }

    public static BooleanExpressionEvaluator create(String expression) {
        return new BooleanExpressionEvaluator(expression, BooleanExpressionEvaluator.tokenize(expression));
    }

    public static BooleanExpressionEvaluator of(String expression) {
        return (BooleanExpressionEvaluator)EXPRESSION_CACHE.getUnchecked((Object)expression);
    }

    public Boolean evaluate(VariableResolver variableResolver) {
        this.values.clear();
        this.operators.clear();
        try {
            for (Token token : this.tokens) {
                token.process(this, variableResolver);
            }
            while (!this.operators.isEmpty()) {
                this.values.push(this.operators.pop().operate(this.values.pop(), this.values.pop()));
            }
            return this.values.pop();
        }
        catch (Exception e) {
            if (((Boolean)FactoryCommonOptions.EXPRESSION_FAIL_LOGGING.get()).booleanValue()) {
                FactoryAPI.LOGGER.warn("Incorrect expression syntax: {} \nExpression: {}", (Object)e.getMessage(), (Object)this.toString());
            }
            return false;
        }
    }

    public static List<Token> tokenize(String expression) {
        Matcher matcher = TOKEN_PATTERN.matcher(expression);
        ArrayList<Token> tokens = new ArrayList<Token>();
        while (matcher.find()) {
            String token;
            if (matcher.group(1) != null) {
                token = matcher.group(1);
                String variableName = token.substring(2, token.length() - 1);
                tokens.add(new Variable(variableName));
            }
            if (matcher.group(2) != null) {
                token = matcher.group(2);
                tokens.add(new BooleanValue(Boolean.parseBoolean(token.startsWith(":") ? token.substring(1) : token)));
                continue;
            }
            if (matcher.group(3) != null) {
                token = matcher.group(3);
                tokens.add(new NumberValue(Double.parseDouble(token.startsWith(":") ? token.substring(1) : token)));
                continue;
            }
            if (matcher.group(4) != null) {
                tokens.add(new Operator(matcher.group(4)));
                continue;
            }
            if (matcher.group(5) == null) continue;
            tokens.add(new Equality(matcher.group(5)));
        }
        return tokens;
    }

    public static interface Token {
        public void process(BooleanExpressionEvaluator var1, VariableResolver var2);

        default public Token relativeToken(BooleanExpressionEvaluator evaluator, int ordinal) {
            int tokenIndex = evaluator.tokens.indexOf(this) + ordinal;
            return tokenIndex < evaluator.tokens.size() && tokenIndex >= 0 ? null : evaluator.tokens.get(tokenIndex);
        }
    }

    public record Operator(String symbol) implements Token
    {
        public boolean operate(boolean b, boolean a) {
            return switch (this.symbol()) {
                case "&" -> a & b;
                case "|" -> a | b;
                case "&&" -> {
                    if (a && b) {
                        yield true;
                    }
                    yield false;
                }
                case "||" -> {
                    if (a || b) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        @Override
        public void process(BooleanExpressionEvaluator evaluator, VariableResolver variableResolver) {
            if (!this.symbol().equals("(") && !this.symbol().equals(")")) {
                while (!evaluator.operators.isEmpty()) {
                    evaluator.values.push(evaluator.operators.pop().operate(evaluator.values.pop(), evaluator.values.pop()));
                }
            } else if (this.symbol().equals(")")) {
                while (evaluator.operators.peek().symbol().equals("(")) {
                    evaluator.values.push(evaluator.operators.pop().operate(evaluator.values.pop(), evaluator.values.pop()));
                }
                evaluator.operators.pop();
                if ("!".equals(evaluator.operators.peek().symbol())) {
                    evaluator.values.push(evaluator.values.pop() == false);
                    evaluator.operators.pop();
                }
                return;
            }
            evaluator.operators.push(this);
        }
    }

    public record Variable(String name) implements NumberLikeValue,
    BooleanLikeValue
    {
        @Override
        public Number numberValue(BooleanExpressionEvaluator evaluator, VariableResolver variableResolver) {
            Number number;
            Token token = this.relativeToken(evaluator, 1);
            if (token instanceof NumberLikeValue) {
                NumberLikeValue value = (NumberLikeValue)token;
                number = value.numberValue(evaluator, variableResolver);
            } else {
                number = null;
            }
            return variableResolver.getNumber(this.name, number);
        }

        @Override
        public Boolean booleanValue(BooleanExpressionEvaluator evaluator, VariableResolver variableResolver) {
            Boolean bl;
            Token token = this.relativeToken(evaluator, 1);
            if (token instanceof BooleanLikeValue) {
                BooleanLikeValue value = (BooleanLikeValue)token;
                bl = value.booleanValue(evaluator, variableResolver);
            } else {
                bl = null;
            }
            return variableResolver.getBoolean(this.name, bl);
        }

        @Override
        public void process(BooleanExpressionEvaluator evaluator, VariableResolver variableResolver) {
            if (this.numberValue(evaluator, variableResolver) != null) {
                return;
            }
            BooleanLikeValue.super.process(evaluator, variableResolver);
        }
    }

    public record BooleanValue(boolean value) implements BooleanLikeValue
    {
        @Override
        public Boolean booleanValue(BooleanExpressionEvaluator evaluator, VariableResolver variableResolver) {
            return this.value;
        }

        @Override
        public void process(BooleanExpressionEvaluator evaluator, VariableResolver variableResolver) {
            Variable v;
            Token token = this.relativeToken(evaluator, -1);
            if (token instanceof Variable && (v = (Variable)token).booleanValue(evaluator, variableResolver) != null) {
                return;
            }
            BooleanLikeValue.super.process(evaluator, variableResolver);
        }
    }

    public record NumberValue(Number value) implements NumberLikeValue
    {
        @Override
        public Number numberValue(BooleanExpressionEvaluator evaluator, VariableResolver variableResolver) {
            return this.value();
        }
    }

    public record Equality(String symbol) implements Token
    {
        public boolean applyEquality(double b, double a) {
            return switch (this.symbol()) {
                case "==" -> {
                    if (a == b) {
                        yield true;
                    }
                    yield false;
                }
                case "!=" -> {
                    if (a != b) {
                        yield true;
                    }
                    yield false;
                }
                case ">=" -> {
                    if (a >= b) {
                        yield true;
                    }
                    yield false;
                }
                case "<=" -> {
                    if (a <= b) {
                        yield true;
                    }
                    yield false;
                }
                case ">" -> {
                    if (a > b) {
                        yield true;
                    }
                    yield false;
                }
                case "<" -> {
                    if (a < b) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        @Override
        public void process(BooleanExpressionEvaluator evaluator, VariableResolver variableResolver) {
            Token token;
            int tokenIndex = evaluator.tokens().indexOf(this);
            if (tokenIndex > 0 && tokenIndex < evaluator.tokens().size() - 1 && (token = evaluator.tokens().get(tokenIndex - 1)) instanceof NumberLikeValue) {
                NumberLikeValue n = (NumberLikeValue)token;
                token = evaluator.tokens().get(tokenIndex + 1);
                if (token instanceof NumberLikeValue) {
                    NumberLikeValue n1 = (NumberLikeValue)token;
                    evaluator.values.push(this.applyEquality(n1.numberValue(evaluator, variableResolver).doubleValue(), n.numberValue(evaluator, variableResolver).doubleValue()));
                }
            }
        }
    }

    public static interface NumberLikeValue
    extends Token {
        public Number numberValue(BooleanExpressionEvaluator var1, VariableResolver var2);

        @Override
        default public void process(BooleanExpressionEvaluator evaluator, VariableResolver variableResolver) {
        }
    }

    public static interface BooleanLikeValue
    extends Token {
        public Boolean booleanValue(BooleanExpressionEvaluator var1, VariableResolver var2);

        @Override
        default public void process(BooleanExpressionEvaluator evaluator, VariableResolver variableResolver) {
            Boolean variable = this.booleanValue(evaluator, variableResolver);
            if (variable == null) {
                return;
            }
            if (!evaluator.operators.isEmpty() && evaluator.operators.peek().symbol().equals("!")) {
                variable = variable == false;
                evaluator.operators.pop();
            }
            evaluator.values.push(variable);
        }
    }
}

