/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.init.FactoryRegistries;

public class FactoryItemUtil {
    public static final Codec<List<Item>> ITEM_COMPONENTS_CODEC = ResourceLocation.CODEC.xmap(r -> (Item)FactoryAPIPlatform.getRegistryValue(r, BuiltInRegistries.ITEM), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)).listOf();
    public static final StreamCodec<RegistryFriendlyByteBuf, List<Item>> ITEM_COMPONENTS_STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries(ITEM_COMPONENTS_CODEC);

    public static CompoundTag getFromJson(JsonObject obj) {
        return CompoundTag.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj).result().orElseGet(CompoundTag::new);
    }

    public static List<Item> getItemComponents(ItemStack itemStack) {
        return (List)itemStack.getOrDefault((DataComponentType)FactoryRegistries.ITEM_COMPONENTS_COMPONENT.get(), new ArrayList());
    }

    public static boolean equalItems(ItemStack itemStack, ItemStack itemStack1) {
        return ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)itemStack1);
    }

    public static boolean compareItems(ItemStack itemStack, ItemStack itemStack1, boolean checkCount) {
        if (checkCount) {
            return ItemStack.matches((ItemStack)itemStack, (ItemStack)itemStack1);
        }
        return FactoryItemUtil.equalItems(itemStack, itemStack1);
    }

    public static boolean hasCustomName(ItemStack stack) {
        return stack.has(DataComponents.CUSTOM_NAME);
    }

    public static void setCustomName(ItemStack stack, Component name) {
        stack.set(DataComponents.CUSTOM_NAME, (Object)name);
    }

    public static int getEnchantmentLevel(ItemStack stack, ResourceKey<Enchantment> enchantment) {
        return FactoryItemUtil.getEnchantmentLevel(stack, enchantment, (RegistryAccess)FactoryAPI.currentServer.registryAccess());
    }

    public static int getEnchantmentLevel(ItemStack stack, ResourceKey<Enchantment> enchantment, RegistryAccess registryAccess) {
        return FactoryAPIPlatform.getRegistryValue(registryAccess, enchantment).map(e -> stack.getEnchantments().getLevel((Holder)e)).orElse(0);
    }
}

