/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public interface SimpleFluidLoggedBlock
extends BucketPickup,
LiquidBlockContainer {
    public static final List<Supplier<Fluid>> BLOCK_LOGGABLE_FLUIDS_SUPPLIER = new ArrayList<Supplier<Fluid>>(List.of(() -> Fluids.EMPTY, () -> Fluids.WATER, () -> Fluids.LAVA));
    public static final Function<Integer, IntegerProperty> DEFAULT_FLUIDLOGGED_PROPERTY = Util.memoize(i -> IntegerProperty.create((String)"fluidlogged", (int)0, (int)i));

    default public IntegerProperty FLUIDLOGGED() {
        return DEFAULT_FLUIDLOGGED_PROPERTY.apply(BLOCK_LOGGABLE_FLUIDS_SUPPLIER.size() - 1);
    }

    default public List<Fluid> getBlockLoggableFluids() {
        return BLOCK_LOGGABLE_FLUIDS_SUPPLIER.stream().map(Supplier::get).toList();
    }

    default public boolean canPlaceLiquid(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        List<Fluid> fluids = this.getBlockLoggableFluids();
        return BLOCK_LOGGABLE_FLUIDS_SUPPLIER.get((Integer)blockState.getValue((Property)this.FLUIDLOGGED())).get().isSame(Fluids.EMPTY) && fluids.contains(fluid);
    }

    default public boolean placeLiquid(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        List<Fluid> fluids = this.getBlockLoggableFluids();
        if (BLOCK_LOGGABLE_FLUIDS_SUPPLIER.get((Integer)blockState.getValue((Property)this.FLUIDLOGGED())).get().isSame(Fluids.EMPTY) && fluids.contains(fluidState.getType())) {
            if (!levelAccessor.isClientSide()) {
                levelAccessor.setBlock(blockPos, (BlockState)blockState.setValue((Property)this.FLUIDLOGGED(), (Comparable)Integer.valueOf(fluids.indexOf(fluidState.getType()))), 3);
                levelAccessor.scheduleTick(blockPos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)levelAccessor));
            }
            return true;
        }
        return false;
    }

    default public FluidState getSimpleFluidState(BlockState state) {
        FluidState fluidState;
        FluidState f = BLOCK_LOGGABLE_FLUIDS_SUPPLIER.get((Integer)state.getValue((Property)this.FLUIDLOGGED())).get().defaultFluidState();
        Fluid fluid = f.getType();
        if (fluid instanceof FlowingFluid) {
            FlowingFluid g = (FlowingFluid)fluid;
            fluidState = g.getSource(false);
        } else {
            fluidState = f;
        }
        return fluidState;
    }

    default public BlockState getStateForPlacement(BlockState state, BlockPlaceContext ctx) {
        int f = this.getBlockLoggableFluids().indexOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType());
        return (BlockState)state.setValue((Property)this.FLUIDLOGGED(), (Comparable)Integer.valueOf(f == -1 ? 0 : f));
    }

    default public ItemStack pickupBlock(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState) {
        if ((Integer)blockState.getValue((Property)this.FLUIDLOGGED()) > 0) {
            Fluid f = BLOCK_LOGGABLE_FLUIDS_SUPPLIER.get((Integer)blockState.getValue((Property)this.FLUIDLOGGED())).get();
            levelAccessor.setBlock(blockPos, (BlockState)blockState.setValue((Property)this.FLUIDLOGGED(), (Comparable)Integer.valueOf(0)), 3);
            if (!blockState.canSurvive((LevelReader)levelAccessor, blockPos)) {
                levelAccessor.destroyBlock(blockPos, true);
            }
            return new ItemStack((ItemLike)f.getBucket());
        }
        return ItemStack.EMPTY;
    }

    default public Optional<SoundEvent> getPickupSound() {
        return Fluids.WATER.getPickupSound();
    }
}

