/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.config;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public interface FactoryConfigControl<T> {
    public static final FactoryConfigControl<Boolean> TOGGLE = FactoryConfigControl.of(Codec.BOOL);

    public Codec<T> codec();

    public static <T> FactoryConfigControl<T> of(Codec<T> codec) {
        return () -> codec;
    }

    public static FromDouble<Double> createDouble() {
        return new FromDouble<Double>((Codec<Double>)Codec.DOUBLE, v -> v, v -> v);
    }

    public record FromDouble<T>(Codec<T> codec, Function<Double, T> valueGetter, Function<T, Double> valueSetter) implements FactoryConfigControl<T>
    {
    }

    public record TextEdit<T>(Codec<T> codec) implements FactoryConfigControl<T>
    {
    }

    public record Int(Codec<Integer> codec, int min, IntSupplier max, int maxEncodable) implements FactoryConfigControl<Integer>
    {
        public Int(int min, IntSupplier max, int maxEncodable) {
            this((Codec<Integer>)Codec.intRange((int)min, (int)maxEncodable), min, max, maxEncodable);
        }
    }

    public record FromInt<T>(Codec<T> codec, Function<Integer, T> valueGetter, Function<T, Integer> valueSetter, Supplier<Integer> valuesSize) implements FactoryConfigControl<T>
    {
        public FromInt(Function<Integer, T> valueGetter, Function<T, Integer> valueSetter, Supplier<Integer> valuesSize) {
            this(Codec.INT.xmap(valueGetter, valueSetter), valueGetter, valueSetter, valuesSize);
        }
    }
}

