/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_8030;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.mixin.base.FontAccessor;
import wily.factoryapi.util.FactoryScreenUtil;

public class AdvancedTextWidget
extends SimpleLayoutRenderable
implements class_364,
class_6379 {
    private final UIAccessor accessor;
    private List<class_5481> lines = Collections.emptyList();
    private int[] widthPerLine = new int[0];
    private int[] heightPerLine = new int[0];
    private int lineSpacing = 12;
    private boolean centered = false;
    private int color = -1;
    private boolean shadow = true;
    private boolean multipleHeights = true;

    public AdvancedTextWidget(UIAccessor accessor) {
        this.accessor = accessor;
    }

    public AdvancedTextWidget withLines(List<class_5481> lines) {
        if (lines != null) {
            this.lines = lines;
            this.processLines();
        }
        return this;
    }

    public void processLines() {
        this.height = 0;
        this.widthPerLine = new int[this.lines.size()];
        this.heightPerLine = new int[this.lines.size()];
        for (int i = 0; i < this.lines.size(); ++i) {
            class_5481 sequence = this.lines.get(i);
            this.widthPerLine[i] = class_310.method_1551().field_1772.method_30880(sequence);
            this.heightPerLine[i] = this.multipleHeights ? Math.max(this.lineSpacing, Math.max(AdvancedTextWidget.getLineHeight(sequence) - 9, 0) + this.lineSpacing) : this.lineSpacing;
            this.height += this.heightPerLine[i];
        }
    }

    public AdvancedTextWidget withLines(class_2561 component, int width) {
        return this.withWidth(width).withLines(class_310.method_1551().field_1772.method_1728((class_5348)component, width));
    }

    public static int getLineHeight(class_5481 sequence) {
        Bearer<Integer> bearer = Bearer.of(0);
        sequence.accept((n, style, pos) -> {
            FontAccessor fontAccessor = (FontAccessor)class_310.method_1551().field_1772;
            fontAccessor.getDefaultFontSet(style.method_27708()).method_2011(pos, fontAccessor.getFilterFishyGlyphs()).bake(sheetGlyphInfo -> {
                int height = Math.round((float)sheetGlyphInfo.method_2032() / sheetGlyphInfo.method_2035());
                if (height > (Integer)bearer.get()) {
                    bearer.set(height);
                }
                return null;
            });
            return true;
        });
        return (Integer)bearer.get();
    }

    public AdvancedTextWidget lineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
        return this;
    }

    public AdvancedTextWidget centered(boolean centered) {
        this.centered = centered;
        return this;
    }

    public AdvancedTextWidget multipleHeights(boolean multipleHeights) {
        this.multipleHeights = multipleHeights;
        return this;
    }

    public AdvancedTextWidget withPos(int x, int y) {
        this.method_48229(x, y);
        return this;
    }

    public AdvancedTextWidget withWidth(int width) {
        this.width = width;
        return this;
    }

    public AdvancedTextWidget withColor(int color) {
        this.color = color;
        return this;
    }

    public AdvancedTextWidget withShadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public List<class_5481> getLines() {
        return this.lines;
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        int actualHeight = this.method_46427();
        for (int i1 = 0; i1 < this.lines.size(); ++i1) {
            int lineHeight = this.heightPerLine[i1];
            guiGraphics.method_51430(class_310.method_1551().field_1772, this.lines.get(i1), this.method_46426() + (this.centered ? (this.width - this.widthPerLine[i1]) / 2 : 0), actualHeight + (lineHeight - this.lineSpacing) / 2, this.color, this.shadow);
            actualHeight += lineHeight;
        }
    }

    public boolean method_25402(double d, double e, int i) {
        if (this.handleComponentsClicked(d, e, i)) {
            return true;
        }
        return super.method_25402(d, e, i);
    }

    public boolean handleComponentsClicked(double d, double e, int i) {
        if (this.accessor.getScreen() != null && this.method_25405(d, e)) {
            if (i == 0) {
                int actualHeight = this.method_46427();
                for (int i1 = 0; i1 < this.lines.size(); ++i1) {
                    int lineHeight = this.heightPerLine[i1];
                    if (e >= (double)actualHeight && e < (double)(actualHeight + lineHeight)) {
                        this.accessor.getScreen().method_25430(class_310.method_1551().field_1772.method_27527().method_30876(this.lines.get(i1), class_3532.method_15357((double)(d - (double)this.method_46426()))));
                        return true;
                    }
                    actualHeight += lineHeight;
                }
            }
            return false;
        }
        return false;
    }

    public boolean method_25405(double d, double e) {
        return FactoryScreenUtil.isMouseOver(d, e, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
    }

    public void method_25365(boolean bl) {
    }

    public boolean method_25370() {
        return false;
    }

    public class_8030 method_48202() {
        return super.method_48202();
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 arg) {
    }
}

