/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_357;
import net.minecraft.class_5676;
import net.minecraft.class_7172;
import net.minecraft.class_7919;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.base.config.FactoryConfigControl;

public class FactoryConfigWidgets {
    private static final List<WidgetOverride<?>> overrides = new ArrayList();
    public static final Function<class_2561, class_7919> TOOLTIP_CACHE = class_156.method_34866(c -> class_7919.method_47407((class_2561)c));

    public static class_7919 getCachedTooltip(class_2561 component) {
        return component == null ? null : TOOLTIP_CACHE.apply(component);
    }

    public static <T> class_339 getOverride(FactoryConfig<T> config, Function<T, class_7919> tooltipFunction, int x, int y, int width, Consumer<T> afterSet) {
        for (WidgetOverride<?> override : overrides) {
            class_339 widgetOverride = override.createWidget(config, tooltipFunction, x, y, width, afterSet);
            if (widgetOverride == null) continue;
            return widgetOverride;
        }
        return null;
    }

    public static <T> class_339 createWidget(FactoryConfig<T> config, int x, int y, int width, Consumer<T> afterSet) {
        Function<Object, class_7919> tooltipFunction = v -> FactoryConfigWidgets.getCachedTooltip(config.getDisplay().tooltip().apply(v));
        class_339 override = FactoryConfigWidgets.getOverride(config, tooltipFunction, x, y, width, afterSet);
        if (override != null) {
            return override;
        }
        if (config.control().equals(FactoryConfigControl.TOGGLE)) {
            return class_5676.method_32606(b -> config.getDisplay().captionFunction().apply(config.getDisplay().name(), (class_2561)b)).method_42729(class_7172.field_38278.method_42721()).method_32618(tooltipFunction::apply).method_32619((Object)((Boolean)config.get())).method_32617(x, y, width, 20, config.getDisplay().name(), (cycleButton, object) -> FactoryConfig.saveOptionAndConsume(config, object, afterSet));
        }
        FactoryConfigControl<T> factoryConfigControl = config.control();
        if (factoryConfigControl instanceof FactoryConfigControl.FromInt) {
            FactoryConfigControl.FromInt c = (FactoryConfigControl.FromInt)factoryConfigControl;
            return class_5676.method_32606(b -> config.getDisplay().captionFunction().apply(config.getDisplay().name(), (class_2561)b)).method_42729(FactoryConfigWidgets.listSupplier(c.valueGetter(), c.valuesSize())).method_32618(tooltipFunction::apply).method_32619(config.get()).method_32617(x, y, width, 20, config.getDisplay().name(), (cycleButton, object) -> FactoryConfig.saveOptionAndConsume(config, object, afterSet));
        }
        factoryConfigControl = config.control();
        if (factoryConfigControl instanceof FactoryConfigControl.FromDouble) {
            FactoryConfigControl.FromDouble c = (FactoryConfigControl.FromDouble)factoryConfigControl;
            return FactoryConfigWidgets.createSlider(config, x, y, width, afterSet, c.valueGetter(), c.valueSetter(), tooltipFunction);
        }
        factoryConfigControl = config.control();
        if (factoryConfigControl instanceof FactoryConfigControl.Int) {
            FactoryConfigControl.Int c = (FactoryConfigControl.Int)factoryConfigControl;
            return FactoryConfigWidgets.createSlider(config, x, y, width, afterSet, d -> (int)((double)(c.max().getAsInt() - c.min()) * d) + c.min(), i -> (double)(i - c.min()) / (double)(c.max().getAsInt() - c.min()), tooltipFunction);
        }
        factoryConfigControl = config.control();
        if (factoryConfigControl instanceof FactoryConfigControl.TextEdit) {
            FactoryConfigControl.TextEdit c = (FactoryConfigControl.TextEdit)factoryConfigControl;
            class_342 editBox = new class_342(class_310.method_1551().field_1772, x, y, width, 20, config.getDisplay().name());
            c.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, config.get()).result().ifPresent(v -> editBox.method_1852(v.toString()));
            editBox.method_1863(s -> {
                DataResult result;
                try {
                    result = c.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)new StringReader((String)s)));
                }
                catch (JsonIOException | JsonSyntaxException e) {
                    result = DataResult.error(() -> ((JsonParseException)e).getMessage());
                }
                if (result.result().isPresent()) {
                    editBox.method_1868(0xE0E0E0);
                    config.set(result.result().get());
                    config.save();
                    editBox.method_47400((class_7919)tooltipFunction.apply(config.get()));
                } else {
                    editBox.method_1868(0xFF5555);
                    editBox.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)((DataResult.Error)result.error().get()).message())));
                }
            });
            return editBox;
        }
        return null;
    }

    public static <T> class_357 createSlider(final FactoryConfig<T> config, int x, int y, int width, final Consumer<T> afterSet, final Function<Double, T> valueGetter, final Function<T, Double> valueSetter, final Function<T, class_7919> tooltipFunction) {
        return new class_357(x, y, width, 20, config.getDisplay().captionFunction().apply(config.getDisplay().name(), (class_2561)config.get()), valueSetter.apply(config.get())){

            protected void method_25346() {
                this.method_25355(config.getDisplay().captionFunction().apply(config.getDisplay().name(), (class_2561)valueGetter.apply(this.field_22753)));
                this.method_47400((class_7919)tooltipFunction.apply(valueGetter.apply(this.field_22753)));
            }

            protected void method_25344() {
                FactoryConfig.saveOptionAndConsume(config, valueGetter.apply(this.field_22753), afterSet);
                this.field_22753 = (Double)valueSetter.apply(config.get());
            }
        };
    }

    public static <T> class_339 createWidget(FactoryConfig<T> config) {
        return FactoryConfigWidgets.createWidget(config, 0, 0, 0, v -> {});
    }

    public static <T> class_5676.class_5680<T> listSupplier(Function<Integer, T> valueGetter, Supplier<Integer> valuesSize) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < valuesSize.get(); ++i) {
            list.add(valueGetter.apply(i));
        }
        return class_5676.class_5680.method_32627(list);
    }

    public static interface WidgetOverride<T> {
        public class_339 createWidget(FactoryConfig<T> var1, Function<T, class_7919> var2, int var3, int var4, int var5, Consumer<T> var6);
    }
}

