/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.ItemContainerPlatform;
import wily.factoryapi.base.FactoryFluidHandler;
import wily.factoryapi.base.IPlatformItemFluidHandler;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.util.FluidInstance;

public class FactoryItemFluidHandler
extends FactoryFluidHandler
implements IPlatformItemFluidHandler {
    private final class_1799 container;

    public FactoryItemFluidHandler(int capacity, class_1799 container) {
        this(capacity, container, f -> true, TransportState.EXTRACT_INSERT);
    }

    public FactoryItemFluidHandler(int capacity, class_1799 stack, Predicate<FluidInstance> validator, TransportState transportState) {
        super(capacity, null, validator, SlotsIdentifier.GENERIC, transportState);
        this.container = stack;
    }

    private class_2487 getFluidCompound(class_1799 stack) {
        return this.isBlockItem() ? stack.method_7948().method_10562("BlockEntityTag").method_10562("singleTank") : stack.method_7948().method_10562(this.getStorageKey());
    }

    public String getStorageKey() {
        return this.isBlockItem() ? "singleTank" : "fluidVariant";
    }

    public boolean isBlockItem() {
        return ItemContainerPlatform.isBlockItem(this.container);
    }

    @Override
    public void setFluid(FluidInstance fluid) {
        boolean b = this.isBlockItem();
        class_2487 tag = this.container.method_7948();
        if (b) {
            tag = tag.method_10562("BlockEntityTag");
        }
        int capacity = this.getMaxFluid();
        class_2487 newTag = FluidInstance.toTag(fluid);
        newTag.method_10569("capacity", capacity);
        tag.method_10566(this.getStorageKey(), (class_2520)newTag);
        if (b) {
            this.container.method_7969().method_10566("BlockEntityTag", (class_2520)tag);
        }
    }

    @Override
    @NotNull
    public FluidInstance getFluidInstance() {
        return FluidInstance.fromTag(this.getFluidCompound(this.container));
    }

    @Override
    public void deserializeTag(class_2487 tag) {
        this.getFluidCompound(this.container).method_10566(this.getStorageKey(), (class_2520)tag);
    }

    @Override
    public class_2487 serializeTag() {
        return this.getFluidCompound(this.container);
    }

    @Override
    public int fill(FluidInstance resource, boolean simulate) {
        if (this.container.method_7947() != 1 || resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        FluidInstance contained = this.getFluidInstance().copy();
        if (contained.isEmpty()) {
            int fillAmount = Math.min(this.getMaxFluid(), resource.getAmount());
            if (!simulate) {
                FluidInstance filled = resource.copy();
                filled.setAmount(fillAmount);
                this.setFluid(filled);
            }
            return fillAmount;
        }
        if (contained.isFluidEqual(resource)) {
            int fillAmount = Math.min(this.getMaxFluid() - contained.getAmount(), resource.getAmount());
            if (!simulate && fillAmount > 0) {
                contained.grow(fillAmount);
                this.setFluid(contained);
            }
            return fillAmount;
        }
        return 0;
    }

    @Override
    @NotNull
    public FluidInstance drain(int maxDrain, boolean simulate) {
        if (this.container.method_7947() != 1 || maxDrain <= 0 || !this.getTransport().canExtract()) {
            return FluidInstance.empty();
        }
        FluidInstance contained = this.getFluidInstance().copy();
        if (contained.isEmpty()) {
            return FluidInstance.empty();
        }
        int drainAmount = Math.min(contained.getAmount(), maxDrain);
        FluidInstance drained = contained.copy();
        drained.setAmount(drainAmount);
        if (!simulate) {
            contained.shrink(drainAmount);
            if (contained.isEmpty()) {
                this.setContainerToEmpty();
            } else {
                this.setFluid(contained);
            }
        }
        return drained;
    }

    protected void setContainerToEmpty() {
        this.container.method_7983(this.getStorageKey());
    }

    @Override
    public void setCapacity(int capacity) {
        boolean b = this.isBlockItem();
        class_2487 tag = this.container.method_7948();
        if (b) {
            tag = tag.method_10562("BlockEntityTag");
        }
        class_2487 newTag = this.getFluidCompound(this.container);
        newTag.method_10569("capacity", capacity);
        tag.method_10566(this.getStorageKey(), (class_2520)newTag);
        if (b) {
            this.container.method_7969().method_10566("BlockEntityTag", (class_2520)tag);
        }
    }

    @Override
    public int getMaxFluid() {
        return this.getFluidCompound(this.container).method_10545("capacity") ? this.getFluidCompound(this.container).method_10550("capacity") : super.getMaxFluid();
    }

    @Override
    public class_1799 getContainer() {
        return this.container;
    }
}

