/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2359;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6898;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.FactoryIngredient;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.FactoryItemUtil;

public class StackIngredient
extends class_1856
implements FactoryIngredient {
    public static final MapCodec<StackIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_6898.method_40388((class_5321)class_7924.field_41197, (Codec)class_7923.field_41178.method_40294(), (boolean)false).fieldOf("items").forGetter(StackIngredient::values), (App)class_2487.field_25128.fieldOf("nbt").forGetter(StackIngredient::getTag), (App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter(StackIngredient::isStrict), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(StackIngredient::getCount)).apply((Applicative)builder, StackIngredient::new));
    public static final CommonNetwork.Identifier<StackIngredient> ID = CommonNetwork.Identifier.create(FactoryAPI.createModLocation("stack_ingredient"), StackIngredient::decode);
    private final class_6885<class_1792> values;
    private final class_2487 tag;
    private final boolean strict;
    protected final class_1799[] stacks;
    private final int count;

    public StackIngredient(class_6885<class_1792> values, class_2487 tag, boolean strict, int count) {
        super(Stream.empty());
        this.values = values;
        this.tag = tag;
        this.strict = strict;
        this.stacks = (class_1799[])values.method_40239().map(i -> {
            class_1799 stack = new class_1799(i, count);
            stack.method_7980(tag);
            return stack;
        }).filter(i -> !i.method_7960()).toArray(class_1799[]::new);
        this.count = count;
    }

    public boolean method_8093(class_1799 stack) {
        if (this.strict) {
            for (class_1799 stack2 : this.stacks) {
                if (!FactoryItemUtil.equalItems(stack, stack2)) continue;
                return true;
            }
            return false;
        }
        return this.values.method_40241(stack.method_41409()) && class_2512.method_10687((class_2520)this.tag, (class_2520)stack.method_7969(), (boolean)true);
    }

    public boolean method_8103() {
        return this.stacks.length == 0;
    }

    public class_1799[] method_8105() {
        return this.stacks;
    }

    public class_6885<class_1792> values() {
        return this.values;
    }

    @Override
    public class_1799[] getStacks() {
        return this.stacks;
    }

    public class_2487 getTag() {
        return this.tag;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public static StackIngredient of(boolean strict, class_1799 stack) {
        return StackIngredient.of(strict, stack, stack.method_7947());
    }

    public static StackIngredient of(boolean strict, class_1799 stack, int count) {
        return new StackIngredient((class_6885<class_1792>)class_6885.method_40246((class_6880[])new class_6880[]{stack.method_41409()}), stack.method_7969(), strict, count);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
        return ID;
    }

    @Override
    public void encode(CommonNetwork.PlayBuf buf) {
        ((class_2540)buf.get()).method_34062(this.values.method_40239().toList(), (b, i) -> b.method_42065((class_2359)class_7923.field_41178, (Object)((class_1792)i.comp_349())));
        ((class_2540)buf.get()).method_10794((class_2520)this.tag);
        ((class_2540)buf.get()).method_52964(this.isStrict());
        ((class_2540)buf.get()).method_52997(this.getCount());
    }

    public static StackIngredient decode(CommonNetwork.PlayBuf buf) {
        return new StackIngredient((class_6885<class_1792>)class_6885.method_40242((List)((List)((class_2540)buf.get()).method_34068(ArrayList::new, b -> (class_6880)b.method_42064(class_7923.field_41178.method_40295())))), ((class_2540)buf.get()).method_10798(), ((class_2540)buf.get()).readBoolean(), ((class_2540)buf.get()).readByte());
    }
}

