/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.network;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;

public abstract class SecureExecutor
implements Executor {
    final Collection<BooleanSupplier> queue = new ConcurrentLinkedQueue<BooleanSupplier>();

    public abstract boolean isSecure();

    public void executeAll() {
        this.queue.removeIf(BooleanSupplier::getAsBoolean);
    }

    @Override
    public void execute(Runnable runnable) {
        this.executeWhen(() -> {
            if (this.isSecure()) {
                runnable.run();
                return true;
            }
            return false;
        });
    }

    public void executeWhen(BooleanSupplier supplier) {
        this.queue.add(supplier);
    }

    public void executeNowIfPossible(BooleanSupplier supplier) {
        if (!supplier.getAsBoolean()) {
            this.executeWhen(supplier);
        }
    }

    static BooleanSupplier createBooleanRunnable(Runnable action, BooleanSupplier supplier) {
        return () -> {
            boolean execute = supplier.getAsBoolean();
            if (execute) {
                action.run();
                return true;
            }
            return false;
        };
    }

    public void executeNowIfPossible(Runnable action, BooleanSupplier supplier) {
        this.executeNowIfPossible(SecureExecutor.createBooleanRunnable(action, supplier));
    }

    public void clear() {
        this.queue.clear();
    }
}

